% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q1Diag.R
\name{corLevDiag}
\alias{corLevDiag}
\title{Correlation or Covariance Matrix for a Diagonal Structure}
\usage{
corLevDiag(par, nlevels, levels, lowerSQRT = FALSE, compGrad = TRUE,
  cov = 0)
}
\arguments{
  
  \item{par}{

    A numeric vector with length \code{npVar} where
    \code{npVar} is the number of variance parameters, namely
    \code{0}, \code{1} or \code{nlevels} corresponding to the values
    of \code{cov}: \code{0}, \code{1} and \code{2}.

  }
  \item{nlevels}{
    
    Number of levels.

  }
  \item{levels}{

    Character representing the levels.

  }
  \item{lowerSQRT}{

    Logical. When \code{TRUE} the (lower) Cholesky
    root \eqn{\mathbf{L}}{L} of the correlation or covariance matrix
    \eqn{\mathbf{C}}{C} is returned instead of the correlation matrix.

  }
  \item{compGrad}{

    Logical. Should the gradient be computed?

  }
  \item{cov}{

    Integer \code{0}, \code{1} or \code{2}. If \code{cov}
    is \code{0}, the matrix is a \emph{correlation} matrix (or its
    Cholesky root) i.e. an identity matrix. If \code{cov} is \code{1}
    or \code{2}, the matrix is a \emph{covariance} (or its square
    root) with constant variance vector for \code{code = 1} and with
    arbitrary variance vector for \code{code = 2}.

  }
}
\value{
  
  A correlation matrix (or its Cholesky root) with the
  optional \code{gradient} attribute.

}
\description{

  Compute the correlation or covariance matrix for a diagonal
  structure.
  
}
\examples{
set.seed(123)
checkGrad <- TRUE
nlevels <- 12
sigma2 <- rexp(n = nlevels)
T0 <- corLevDiag(nlevels = nlevels, par = sigma2, cov = 2)
L0 <- corLevDiag(nlevels = nlevels, par = sigma2, cov = 2,
                 lowerSQRT = TRUE)

}
