% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_global_average_pooling_1d}
\alias{layer_global_average_pooling_1d}
\title{Global average pooling operation for temporal data.}
\usage{
layer_global_average_pooling_1d(
  object,
  data_format = "channels_last",
  keepdims = FALSE,
  ...
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{data_format}{One of \code{channels_last} (default) or \code{channels_first}.
The ordering of the dimensions in the inputs.}

\item{keepdims}{A boolean, whether to keep the spatial dimensions or not. If
\code{keepdims} is \code{FALSE} (default), the rank of the tensor is reduced for
spatial dimensions. If \code{keepdims} is \code{TRUE}, the spatial dimensions are
retained with length 1. The behavior is the same as for \code{tf.reduce_mean} or
\code{np.mean}.}

\item{...}{standard layer arguments.}
}
\description{
Global average pooling operation for temporal data.
}
\section{Input shape}{

3D tensor with shape: \verb{(batch_size, steps, features)}.
}

\section{Output shape}{

2D tensor with shape: \verb{(batch_size, channels)}
}

\seealso{
Other pooling layers: 
\code{\link{layer_average_pooling_1d}()},
\code{\link{layer_average_pooling_2d}()},
\code{\link{layer_average_pooling_3d}()},
\code{\link{layer_global_average_pooling_2d}()},
\code{\link{layer_global_average_pooling_3d}()},
\code{\link{layer_global_max_pooling_1d}()},
\code{\link{layer_global_max_pooling_2d}()},
\code{\link{layer_global_max_pooling_3d}()},
\code{\link{layer_max_pooling_1d}()},
\code{\link{layer_max_pooling_2d}()},
\code{\link{layer_max_pooling_3d}()}
}
\concept{pooling layers}
