% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{image_to_array}
\alias{image_to_array}
\alias{image_array_resize}
\alias{image_array_save}
\title{3D array representation of images}
\usage{
image_to_array(img, data_format = c("channels_last", "channels_first"))

image_array_resize(img, height, width, data_format = c("channels_last",
  "channels_first"))

image_array_save(img, path, data_format = NULL, file_format = NULL,
  scale = TRUE)
}
\arguments{
\item{img}{Image}

\item{data_format}{Image data format ("channels_last" or "channels_first")}

\item{height}{Height to resize to}

\item{width}{Width to resize to}

\item{path}{Path to save image to}

\item{file_format}{Optional file format override. If omitted, the format to
use is determined from the filename extension. If a file object was used
instead of a filename, this parameter should always be used.}

\item{scale}{Whether to rescale image values to be within 0,255}
}
\description{
3D array that represents an image with dimensions (height,width,channels) or
(channels,height,width) depending on the data_format.
}
\seealso{
Other image preprocessing: \code{\link{fit_image_data_generator}},
  \code{\link{flow_images_from_data}},
  \code{\link{flow_images_from_directory}},
  \code{\link{image_load}}
}
