% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_maximum}
\alias{layer_maximum}
\title{Layer that computes the maximum (element-wise) a list of inputs.}
\usage{
layer_maximum(inputs, ...)
}
\arguments{
\item{inputs}{A input tensor, or list of input tensors. Can be missing.}

\item{...}{Unnamed args are treated as additional \code{inputs}. Named arguments are passed on as standard layer arguments.}
}
\value{
A tensor, the element-wise maximum of the inputs. If \code{inputs} is
missing, a keras layer instance is returned.
}
\description{
It takes as input a list of tensors, all of the same shape, and returns a
single tensor (also of the same shape).
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/maximum}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Maximum}
\item \url{https://keras.io/api/layers/merging_layers/maximum}
}

Other merge layers: 
\code{\link{layer_average}()},
\code{\link{layer_concatenate}()},
\code{\link{layer_dot}()},
\code{\link{layer_minimum}()},
\code{\link{layer_multiply}()},
\code{\link{layer_subtract}()}
}
\concept{merge layers}
