% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_weights_hdf5}
\alias{save_model_weights_hdf5}
\alias{load_model_weights_hdf5}
\title{Save/Load model weights using HDF5 files}
\usage{
save_model_weights_hdf5(object, filepath, overwrite = TRUE)

load_model_weights_hdf5(
  object,
  filepath,
  by_name = FALSE,
  skip_mismatch = FALSE,
  reshape = FALSE
)
}
\arguments{
\item{object}{Model object to save/load}

\item{filepath}{Path to the file}

\item{overwrite}{Whether to silently overwrite any existing
file at the target location}

\item{by_name}{Whether to load weights by name or by topological order.}

\item{skip_mismatch}{Logical, whether to skip loading of layers
where there is a mismatch in the number of weights, or a mismatch in the
shape of the weight (only valid when \code{by_name = FALSE}).}

\item{reshape}{Reshape weights to fit the layer when the correct number
of values are present but the shape does not match.}
}
\description{
Save/Load model weights using HDF5 files
}
\details{
The weight file has:
\itemize{
\item \code{layer_names} (attribute), a list of strings (ordered names of model layers).
\item For every layer, a \code{group} named \code{layer.name}
\item For every such layer group, a group attribute \code{weight_names}, a list of strings
(ordered names of weights tensor of the layer).
\item For every weight in the layer, a dataset storing the weight value, named after
the weight tensor.
}

For \code{load_model_weights()}, if \code{by_name} is \code{FALSE} (default) weights are
loaded based on the network's topology, meaning the architecture should be
the same as when the weights were saved. Note that layers that don't have
weights are not taken into account in the topological ordering, so adding
or removing layers is fine as long as they don't have weights.

If \code{by_name} is \code{TRUE}, weights are loaded into layers only if they share
the same name. This is useful for fine-tuning or transfer-learning models
where some of the layers have changed.
}
\seealso{
Other model persistence: 
\code{\link{get_weights}()},
\code{\link{model_to_json}()},
\code{\link{model_to_yaml}()},
\code{\link{save_model_hdf5}()},
\code{\link{save_model_tf}()},
\code{\link{serialize_model}()}
}
\concept{model persistence}
