% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrier_crossing.R
\name{ladder_moment}
\alias{ladder_moment}
\title{Estimate the distribution of first ladder moment for given level}
\usage{
ladder_moment(simulations, level)
}
\arguments{
\item{simulations}{kendall_simulation object}

\item{level}{Positive numeric}
}
\value{
tibble
}
\description{
NA is returned if the level wasn't crossed. Printing the resulting object
will give summary of the estimated distribution and information whether
level wasn't crossed in some simulations. This information can be used to
pick the right trajectory length for the given level.
}
\examples{
{
kendall_rw <- simulate_kendall_rw(100, 100, runif, 0.5)
estim_ladder <- ladder_moment(kendall_rw, 1000)
estim_ladder
}

}
