% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Keir.R
\name{Keir}
\alias{Kei}
\alias{Keir}
\alias{Keir.default}
\alias{Ker}
\title{Complementary solution to the Kelvin differential equation (K)}
\usage{
Keir(x, ...)

\method{Keir}{default}(x, nu. = 0, nSeq. = 1, add.tol = TRUE,
  return.list = FALSE, show.scaling = FALSE, ...)

Kei(...)

Ker(...)
}
\arguments{
\item{x}{numeric; values to evaluate the complex solution at}

\item{...}{additional arguments passed to \code{\link[Bessel]{BesselK}} or \code{\link{Keir}}}

\item{nu.}{numeric; value of \eqn{\nu} in \eqn{\mathcal{K}_\nu}{Kei,Ker} solutions}

\item{nSeq.}{positive integer; equivalent to \code{nSeq} in \code{\link[Bessel]{BesselK}}}

\item{add.tol}{logical; Should a fudge factor be added to prevent an error for zero-values?}

\item{return.list}{logical; Should the result be a list instead of matrix?}

\item{show.scaling}{logical; Should the normalization values be given as a message?}
}
\value{
If \code{return.list==FALSE} (the default),
a complex matrix with as many columns as using \code{nSeq.} creates.
Otherwise the result is a list with matrices for
Real and Imaginary components.
}
\description{
This function calculates the complex solution to the Kelvin differential
equation using modified Bessel functions of the \emph{second kind}, specifically
those produced by \code{\link[Bessel]{BesselK}}.
}
\details{
\code{\link{Ker}} and \code{\link{Kei}} are wrapper functions
which return the real and imaginary components of \code{\link{Keir}},, respectively.
}
\examples{
Keir(1:10)    # defaults to nu.=0, nSeq=1
Keir(1:10, nu.=2)
Keir(1:10, nSeq=2)
Keir(1:10, nSeq=2, return.list=TRUE)
# Imaginary component only
Kei(1:10)
# Real component only
Ker(1:10)
}
\author{
Andrew Barbour
}
\references{
\url{http://mathworld.wolfram.com/KelvinFunctions.html}

Imaginary: \url{http://mathworld.wolfram.com/Kei.html}

Real: \url{http://mathworld.wolfram.com/Ker.html}
}
\seealso{
\code{\link{kelvin-package}}, \code{\link{Beir}}, \code{\link[Bessel]{BesselK}}
}

