% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdevine.R
\name{rkdevine}
\alias{rkdevine}
\title{Simulate from a kdevine object}
\usage{
rkdevine(n, obj)
}
\arguments{
\item{n}{number of observations.}

\item{obj}{a \code{kdevine} object.}
}
\value{
An \eqn{n x d} matrix of simulated data from the \code{kdevine}
object.
}
\description{
Simulate from a kdevine object
}
\examples{
# load and plot data
data(wdbc)
\dontshow{wdbc <- wdbc[1:30, ]}
# estimate density
fit <- kdevine(wdbc[, 5:7], xmin = rep(0, 3))

# plot simulated data
pairs(rkdevine(nrow(wdbc), fit))

}
\seealso{
\code{\link{kdevine}},
\code{\link{rkdevinecop}},
\code{\link{rkde1d}}
}

