% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdevine.R
\name{kdevine}
\alias{kdevine}
\title{Kernel density estimatior based on simplified vine copulas}
\usage{
kdevine(data, mult.1d = 1, xmin = NULL, xmax = NULL,
  copula.type = "kde", ...)
}
\arguments{
\item{data}{(\eqn{n x d}) data matrix.}

\item{mult.1d}{numeric; all bandwidhts for marginal kernel density estimation
are multiplied with \code{mult.1d}.}

\item{xmin}{numeric vector of length d; see \code{\link{kde1d}}.}

\item{xmax}{numeric vector of length d; see \code{\link{kde1d}}.}

\item{copula.type}{either \code{"kde"} (default) or \code{"parametric"} for
kernel or parametric estimation of the vine copula.}

\item{...}{further arguments passed to \code{\link{kde1d}} or
\code{\link{kdevinecop}}.}
}
\value{
An object of class \code{kdevine}.
}
\description{
Implements the vine-copula based estimator of Nagler and Czado (2016). The
marginal densities are estimated by \code{\link{kde1d}}, the vine copula
density by \code{\link{kdevinecop}}.
}
\examples{
# load data
data(wdbc, package = "kdecopula")
\dontshow{wdbc <- wdbc[1:30, ]}
# estimate density (use xmin to indicate positive support)
fit <- kdevine(wdbc[, 5:7], xmin = rep(0, 3))

# evaluate density estimate
dkdevine(c(1000, 0.1, 0.1), fit)

# plot simulated data
pairs(rkdevine(nrow(wdbc), fit))

}
\references{
Nagler, T., Czado, C. (2016) \cr
Evading the curse of dimensionality in nonparametric density estimation with
simplified vine copulas. \cr
\emph{Journal of Multivariate Analysis 151, 69-89 (doi:10.1016/j.jmva.2016.07.003)}
}
\seealso{
\code{\link{dkdevine}}
\code{\link{kde1d}}
\code{\link{kdevinecop}}
}

