% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriate_rank.R
\docType{methods}
\name{seriate_rank}
\alias{seriate_rank}
\alias{seriate_rank-method}
\alias{seriate_rank,data.frame-method}
\alias{seriate_rank,matrix-method}
\title{Reciprocal Ranking Seriation}
\usage{
seriate_rank(object, ...)

\S4method{seriate_rank}{data.frame}(object, EPPM = FALSE, margin = c(1, 2), stop = 100)

\S4method{seriate_rank}{matrix}(object, EPPM = FALSE, margin = c(1, 2), stop = 100)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Currently not used.}

\item{EPPM}{A \code{\link{logical}} scalar: should the seriation be computed on EPPM
instead of raw data?}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows then columns, \code{c(2, 1)} indicates columns
then rows.}

\item{stop}{An \code{\link{integer}} giving the stopping rule (i.e. maximum number of
iterations) to avoid infinite loop.}
}
\value{
A \linkS4class{RankPermutationOrder} object.
}
\description{
Reciprocal Ranking Seriation
}
\details{
This procedure iteratively rearrange rows and/or columns according to their
weighted rank in the data matrix until convergence.

Note that this procedure could enter into an infinite loop. If no
convergence is reached before the maximum number of iterations, it stops
with a warning.
}
\examples{
## Replicates Desachy 2004 results
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
get_order(indices, 1) # rows
get_order(indices, 2) # columns

## Permute columns
(new <- permute(compiegne, indices))

## See the vignette
\dontrun{
utils::vignette("seriation")
}
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.

Dunnell, R. C. (1970). Seriation Method and Its Evaluation. \emph{American
Antiquity}, 35(03), 305-319. \doi{10.2307/278341}.

Ihm, P. (2005). A Contribution to the History of Seriation in Archaeology.
In C. Weihs & W. Gaul (Eds.), \emph{Classification: The Ubiquitous
Challenge}. Berlin Heidelberg: Springer, p. 307-316.
\doi{10.1007/3-540-28084-7_34}.
}
\seealso{
Other seriation methods: 
\code{\link{permute}()},
\code{\link{seriate_average}()},
\code{\link{seriate_refine}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
