\name{BellPol}
\alias{BellPol}
\title{
Bell polynomials
}
\description{The routine generates complete and partial exponential Bell polynomials, as well as complete and partial ordinary 
Bell polynomials.}

\usage{
BellPol(n = 0, m = 0, b = TRUE)
}

\arguments{
  \item{n}{integer, the degree of the polynomial}
  \item{m}{integer, the fixed degree of each monomial in the polynomial}
  \item{b}{boolean, TRUE (default) for exponential Bell polynomials, FALSE for ordinary Bell polynomials}
}

\details{Faa di Bruno's formula gives the coefficients of the exponential formal power series obtained from the composition 
of the exponential formal power series f() and g(). Complete exponential Bell polynomials in the variables y1,...,yn are 
generated by setting f[i]=1 and g[i]=yi, for each i from 1 to n. Partial exponential Bell polynomials are polynomials 
in the variables y1,...,yn with fixed degree m for each of the involved monomials. Partial exponential Bell 
polynomials are recovered from Faa di Bruno's formula by setting f[i]=1 if i=m, f[i]=0 otherwise and g[i]=yi for each i from 1 to n.
Observe that complete exponential Bell polynomials are the summation of partial exponential Bell polynomials for m from 1 to n. \cr 
Partial ordinary Bell polynomials in the variables y1,...,yn are recovered from Faa di Bruno's formula setting 
f[i]=1 if i=m, f[i]=0 otherwise and g[i]=i! yi for each i from 1 to n. Complete ordinary Bell polynomials are recovered from Faa di 
Bruno's formula by setting f[i]=1 and g[i]=i!yi for each i from 1 to n. Observe that complete ordinary 
Bell polynomials are the summation of partial ordinary Bell polynomials for m from 1 to n.}

\value{
 \item{string}{the expression of the generated Bell polynomial}
}

\references{

Charalambides C.A. (2002) Enumerative Combinatoris, Chapman & Haii/CRC. 

E. Di Nardo, G. Guarino, D. Senato (2008) An unifying framework for k-statistics, polykays and their generalizations. 
Bernoulli. 14(2), 440-468. (download from \url{http://arxiv.org/pdf/math/0607623.pdf}) 
 
E. Di Nardo, G. Guarino, D. Senato (2008) Symbolic computation of moments of sampling distributions. 
Comp. Stat. Data Analysis. 52(11), 4909-4922. (download from \url{http://arxiv.org/abs/0806.0129}) 

E. Di Nardo, G. Guarino, D. Senato (2011) A new algorithm for computing the multivariate Faa di Bruno's formula. 
Appl. Math. Comp. 217, 6286--6295. (download from \url{http://arxiv.org/abs/1012.6008})

}

\author{
Elvira Di Nardo \email{elvira.dinardo@unito.it},\cr 
Giuseppe Guarino \email{giuseppe.guarino@rete.basilicata.it}
}

\section{Warning}{The value of the first parameter is the same as the MFB function in the univariate with univariate case composition.}

\note{This function calls the \code{\link{MFB}} function in the package \code{kStatistics}.}


\seealso{
\code{\link{MFB}}
}


\examples{

# Complete ordinary Bell Polynomial n=5, that is 
# (y1^5) + 20(y1^3)(y2) + 30(y1)(y2^2) + 60(y1^2)(y3) + 120(y2)(y3) + 120(y1)(y4) + 120(y5)
BellPol(5,,FALSE)
# or
BellPol(5,0,FALSE)

# Complete exponential Bell Polynomial n=5, that is 
# (y1^5) + 10(y1^3)(y2) + 15(y1)(y2^2) + 10(y1^2)(y3) + 10(y2)(y3) + 5(y1)(y4) + (y5)
BellPol(5)

# Partial ordinary Bell polynomial n=5 and m=3, that is 
# 30(y1)(y2^2) + 60(y1^2)(y3)
BellPol(5,3,FALSE)

# Partial exponential Bell Polynomial n=5 and m=3, that is 
# 15(y1)(y2^2) + 10(y1^2)(y3)
BellPol(5,3)

}

% R KEYWORDS
\keyword{ univar }
\keyword{ list }
\keyword{ symbolmath }
\keyword{ combinatorics }