% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{CAR_prior}
\alias{CAR_prior}
\title{CAR prior}
\usage{
CAR_prior(
  block,
  adj.matrix,
  scale,
  rho,
  sum.zero = FALSE,
  var.index = 1:block$n
)
}
\arguments{
\item{block}{dlm_block object: The structural block.}

\item{adj.matrix}{matrix: The adjacency matrix.}

\item{scale}{numeric: The tau parameter for the CAR model (see references).}

\item{rho}{numeric: The rho parameter for the CAR model (see references).}

\item{sum.zero}{Bool: If true, all latent states will add to 0.}

\item{var.index}{integer: The index of the variables from which to set the prior.}
}
\value{
A dlm_block object with the desired prior.
}
\description{
Defines the prior of a structural block as a Conditional Autoregressive (CAR) prior.
}
\details{
The filtering algorithm used in this package requires a proper prior for the latent space. As such, this implementation of the CAR prior imposes a zero-sum constraint in the regional effects.
The discount factor must be the same for all variables whose prior is being modified.

For a revision of the CAR prior, see \insertCite{AlexCar;textual}{kDGLM}.

For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

# Creating an arbitrary adjacency matrix
adj.matrix <- matrix(
  c(
    0, 1, 1, 0, 0,
    1, 0, 1, 0, 0,
    1, 1, 0, 0, 0,
    0, 0, 0, 0, 1,
    0, 0, 0, 1, 0
  ),
  5, 5,
  byrow = TRUE
)

polynomial_block(mu = 1, D = 0.95) |>
  block_mult(5) |>
  CAR_prior(scale = 9, rho = 1, adj.matrix = adj.matrix)

}
\references{
\insertAllCited{}
}
\seealso{
Auxiliary functions for creating structural blocks \code{\link{polynomial_block}}, \code{\link{regression_block}}, \code{\link{harmonic_block}}, \code{\link{TF_block}}.

Other auxiliary functions for defining priors.: 
\code{\link{joint_prior}()},
\code{\link{zero_sum_prior}()}
}
\concept{auxiliary functions for defining priors.}
