
<!-- README.md is generated from README.Rmd. Please edit that file -->

# <img src='img/hex-logo.png' align="right" height="200" /> justifier 📦

## Human and Machine-Readable Justifications and Justified Decisions Based on ‘YAML’

<!-- badges: start -->

[![Pipeline
status](https://gitlab.com/r-packages/justifier/badges/prod/pipeline.svg)](https://gitlab.com/r-packages/justifier/-/commits/prod)

[![Coverage
status](https://codecov.io/gl/r-packages/justifier/branch/prod/graph/badge.svg)](https://codecov.io/gl/r-packages/justifier?branch=prod)

<!-- [![Dependency status](https://tinyverse.netlify.com/badge/justifier)](https://CRAN.R-project.org/package=justifier) -->
<!-- badges: end -->

The pkgdown website for this project is located at
<https://r-packages.gitlab.io/justifier>.

<!--------------------------------------------->
<!-- Start of a custom bit for every package -->
<!--------------------------------------------->

The goal of `justifier` is to provide a simple human- and
machine-readable standard for documenting justifications for decisions.
`justifier` was primarily developed to enable documenting the
development of behavior change interventions and the planning and
execution of scientific studies, but it can also be used to document
decisions in organisations, enabling deriving insights in decision
processes from the accumulation of decisions and types of justifications
over time.

Three vignettes (in progress) are located at:

-   <https://r-packages.gitlab.io/justifier/articles/general-introduction-to-justifier.html>
-   <https://r-packages.gitlab.io/justifier/articles/justifier-in-study-design.html>
-   <https://r-packages.gitlab.io/justifier/articles/justifier-in-intervention-development.html>

This meets the increasing demand for accountability of professionals
(see e.g. Van Woerkum & Aarts, 2012).

<!--------------------------------------------->
<!--  End of a custom bit for every package  -->
<!--------------------------------------------->

## Installation

You can install the released version of `justifier` from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages('justifier');
```

You can install the development version of `justifier` from
[GitLab](https://about.gitlab.com) with:

``` r
remotes::install_gitlab('r-packages/justifier');
```

(assuming you have `remotes` installed; otherwise, install that first
using the `install.packages` function)

<!--------------------------------------------->
<!-- Start of a custom bit for every package -->
<!--------------------------------------------->

## References

van Woerkum, C. and Aarts, N. (2012), ‘Accountability: New challenges,
new forms’, *Journal of Organizational Transformation & Social Change*,
9, pp. 271–283, .

<!--------------------------------------------->
<!--  End of a custom bit for every package  -->
<!--------------------------------------------->
