% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_plot.R
\name{interact_plot}
\alias{interact_plot}
\title{Plot interaction effects in regression models}
\usage{
interact_plot(model, pred, modx, modxvals = NULL, mod2 = NULL,
  mod2vals = NULL, centered = NULL, standardize = FALSE, n.sd = 1,
  plot.points = FALSE, interval = FALSE, int.type = c("confidence",
  "prediction"), int.width = 0.95, outcome.scale = "response",
  x.label = NULL, y.label = NULL, modx.labels = NULL,
  mod2.labels = NULL, main.title = NULL, legend.main = NULL,
  color.class = NULL, line.thickness = 1.1, vary.lty = TRUE)
}
\arguments{
\item{model}{A regression model of type \code{lm}, \code{glm},
\code{\link[survey]{svyglm}}, or \code{\link[lme4]{merMod}}. It should
contain the interaction of interest.}

\item{pred}{The name of the predictor variable involved
in the interaction.}

\item{modx}{The name of the moderator variable involved
in the interaction.}

\item{modxvals}{For which values of the moderator should lines be plotted?
Default is \code{NULL}. If \code{NULL}, then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If the moderator is a factor variable and \code{modxvals} is
\code{NULL}, each level of the factor is included. If
\code{"plus-minus"}, plots lines when the moderator is at +/- 1 standard
deviation without the mean.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction.}

\item{mod2vals}{For which values of the second moderator should the plot be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modxvals}.}

\item{centered}{A vector of quoted variable names that are to be mean-centered. If
\code{NULL}, all non-focal predictors are centered. If not \code{NULL}, only
the user-specified predictors are centered. User can also use "none" or "all"
arguments. The response variable is not centered unless specified directly.}

\item{standardize}{Logical. Would you like to standardize the variables
that are centered? Default is \code{FALSE}, but if \code{TRUE} it will
standardize variables specified by the \code{centered} argument. Note that
non-focal predictors are centered when \code{centered = NULL}, its default.}

\item{n.sd}{How many standard deviations should be used if \code{standardize
= TRUE}? Default is 1, but some prefer 2.}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as a
scatterplot on top of the interaction lines. If moderator is a factor, the dots
will be the same color as their parent factor.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction intervals
the line using \code{\link[ggplot2]{geom_ribbon}}. Not supported for
\code{merMod} models.}

\item{int.type}{Type of interval to plot. Options are "confidence" or "prediction".
Default is confidence interval.}

\item{int.width}{How large should the interval be, relative to the standard error?
The default, .95, corresponds to roughly 1.96 standard errors and a .05 alpha
level for values outside the range. In other words, for a confidence interval,
.95 is analogous to a 95\% confidence interval.}

\item{outcome.scale}{For nonlinear models (i.e., GLMs), should the outcome
variable be plotted on the link scale (e.g., log odds for logit models) or
the original scale (e.g., predicted probabilities for logit models)? The
default is \code{"response"}, which is the original scale. For the link
scale, which will show straight lines rather than curves, use
\code{"link"}.}

\item{x.label}{A character object specifying the desired x-axis label. If \code{NULL},
the variable name is used.}

\item{y.label}{A character object specifying the desired x-axis label. If \code{NULL},
the variable name is used.}

\item{modx.labels}{A character vector of labels for each level of the moderator values,
provided in the same order as the \code{modxvals} argument. If \code{NULL},
the values themselves are used as labels unless \code{modxvals} is also \code{NULL}.
In that case, "+1 SD" and "-1 SD" are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd moderator
values, provided in the same order as the \code{mod2vals} argument. If \code{NULL},
the values themselves are used as labels unless \code{mod2vals} is also \code{NULL}.
In that case, "+1 SD" and "-1 SD" are used.}

\item{main.title}{A character object that will be used as an overall title for the
plot. If \code{NULL}, no main title is used.}

\item{legend.main}{A character object that will be used as the title that appears
above the legend. If \code{NULL}, the name of the moderating variable is used.}

\item{color.class}{Any palette argument accepted by
\code{\link[ggplot2]{scale_colour_brewer}}. Default is "Set2" for factor moderators,
"Blues" for +/- SD and user-specified \code{modxvals} values.}

\item{line.thickness}{How thick should the plotted lines be? Default is 1.1;
ggplot's default is 1.}

\item{vary.lty}{Should the resulting plot have different shapes for each line
in addition to colors? Defaults to \code{TRUE}.}
}
\value{
The functions returns a \code{ggplot} object, which can be treated like
  a user-created plot and expanded upon as such.
}
\description{
\code{interact_plot()} plots regression lines at user-specified levels of a moderator
variable to explore interactions. The plotting is done with \code{ggplot2} rather than
base graphics, which some similar functions use.
}
\details{
This function provides a means for plotting conditional effects for the
  purpose of exploring interactions in the context of regression. You must have the
  package \code{ggplot2} installed to benefit from these plotting functions.

  The function is designed for two-way interactions. For additional terms, the
  \code{\link[effects]{effects}} package may be better suited to the task.

  This function supports nonlinear models and by default will plot them on
  their original scale (\code{outcome.scale = "response"}).

  While mixed effects models from \code{lme4} are supported, only the fixed
  effects are plotted.
}
\examples{
# Using a fitted lm model
states <- as.data.frame(state.x77)
states$HSGrad <- states$`HS Grad`
fit <- lm(Income ~ HSGrad + Murder*Illiteracy,
  data = states)
interact_plot(model = fit, pred = Murder,
  modx = Illiteracy)

# Using interval feature
fit <- lm(accel ~ mag*dist, data=attenu)
interact_plot(fit, pred = mag, modx = dist, interval = TRUE,
  int.type = "confidence", int.width = .8)

# Using second moderator
fit <- lm(Income ~ HSGrad*Murder*Illiteracy,
  data = states)
interact_plot(model = fit, pred = Murder,
  modx = Illiteracy, mod2 = HSGrad)

# With svyglm
library(survey)
data(api)
dstrat <- svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
regmodel <- svyglm(api00~ell*meals,design=dstrat)
interact_plot(regmodel, pred = ell, modx = meals)

# With lme4
\dontrun{
library(lme4)
data(VerbAgg)
mv <- glmer(r2 ~ Anger * mode + (1 | item), data = VerbAgg, family = binomial,
            control = glmerControl("bobyqa"))
interact_plot(mv, pred = Anger, modx = mode)
}

}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and multilevel
 regression: Inferential and graphical techniques. \emph{Multivariate Behavioral
 Research}, \emph{40}(3), 373-400.
 \url{http://dx.doi.org/10.1207/s15327906mbr4003_5}

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). \emph{Applied multiple
regression/correlation analyses for the behavioral sciences} (3rd ed.).
Mahwah, NJ: Lawrence Erlbaum Associates, Inc.
}
\seealso{
\code{\link[rockchalk]{plotSlopes}} performs a similar function, but
  but with the base graphics package--this function is meant, in part, to simulate
  its features.

  \code{\link{sim_slopes}} performs a simple slopes analysis with a similar
  argument syntax to this function.

Other interaction tools: \code{\link{johnson_neyman}},
  \code{\link{probe_interaction}}, \code{\link{sim_slopes}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
