% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilePsInput.R
\name{FilePsInput}
\alias{FilePsInput}
\title{FilePsInput: Shiny module UI for file upload for propensity score matching.}
\usage{
FilePsInput(id, label = "Upload data (csv/xlsx/sav/sas7bdat/dta)")
}
\arguments{
\item{id}{id}

\item{label}{label, Default: 'csv/xlsx/sav/sas7bdat file'}
}
\value{
Shiny module UI for file upload for propensity score matching.
}
\description{
Shiny module UI for file upload for propensity score matching.
}
\details{
Shiny module UI for file upload for propensity score matching.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(readxl)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      FilePsInput("datafile")
    ),
    mainPanel(
      tabsetPanel(
        type = "pills",
        tabPanel("Data", DTOutput("data")),
        tabPanel("Matching data", DTOutput("matdata")),
        tabPanel("Label", DTOutput("data_label", width = "100\%"))
      )
    )
  )
)

server <- function(input, output, session) {
  mat.info <- callModule(FilePs, "datafile")

  output$data <- renderDT({
    mat.info()$data
  })

  output$matdata <- renderDT({
    mat.info()$matdata
  })

  output$label <- renderDT({
    mat.info()$label
  })
}
}
