% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileRepeatedInput.R
\name{FileRepeatedInput}
\alias{FileRepeatedInput}
\title{FileRepeatedInput: File upload UI for repeated measure analysis.}
\usage{
FileRepeatedInput(id, label = "Upload data (csv/xlsx/sav/sas7bdat/dta)")
}
\arguments{
\item{id}{id}

\item{label}{label, Default: 'csv/xlsx/sav/sas7bdat/dta file'}
}
\value{
File upload UI for repeated measure analysis.
}
\description{
File upload UI for repeated measure analysis.
}
\details{
File upload UI for repeated measure analysis.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(readxl)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      FileRepeatedInput("datafile")
    ),
    mainPanel(
      tabsetPanel(
        type = "pills",
        tabPanel("Data", DTOutput("data")),
        tabPanel("Label", DTOutput("data_label", width = "100\%"))
      )
    )
  )
)

server <- function(input, output, session) {
  data <- callModule(FileRepeated, "datafile")

  output$data <- renderDT({
    data()$data
  })

  output$label <- renderDT({
    data()$label
  })
}
}
