% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/js_validate.R
\name{js_validate_script}
\alias{js_validate_script}
\title{Validate JavaScript}
\usage{
js_validate_script(text, error = TRUE)
}
\arguments{
\item{text}{character vector with JavaScript code}

\item{error}{raise error on invalid code}
}
\description{
Simple wrapper for \code{ct$validate} in \code{\link{V8}}.
Tests if code constitutes a syntactically valid JS script.
}
\examples{
js_validate_script("function foo(x){2*x}") #TRUE
js_validate_script("foo = function(x){2*x}") #TRUE

# Anonymous functions in global scope are invalid
js_validate_script("function(x){2*x}", error = FALSE) #FALSE

# Use ! or () to check anonymous function syntax
js_validate_script("!function(x){2*x}") #TRUE
js_validate_script("(function(x){2*x})") #TRUE
}

