% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jq.R
\name{jq}
\alias{jq}
\alias{jq.jqr}
\alias{jq.character}
\alias{jq.json}
\alias{jq.connection}
\title{Execute a query with jq}
\usage{
jq(x, ...)

\method{jq}{jqr}(x, ...)

\method{jq}{character}(x, ..., flags = jq_flags())

\method{jq}{json}(x, ..., flags = jq_flags())

\method{jq}{connection}(x, ..., flags = jq_flags(), out = NULL)
}
\arguments{
\item{x}{\code{json} object or character string with json data. this can
be one or more valid json objects}

\item{...}{character specification of jq query. Each element in \code{...}
will be combined with " | ", which is convenient for long queries.}

\item{flags}{See \code{\link{jq_flags}}}

\item{out}{a filename, callback function, connection object to stream output.
Set to `NULL` to buffer all output and return a character vector.}
}
\description{
\code{jq} is meant to work with the high level interface in this package.
\code{jq} also provides access to the low level interface in which you can
use jq query strings just as you would on the command line. Output gets
class of json, and pretty prints to the console for easier viewing.
\code{jqr} doesn't do pretty printing.
}
\examples{
'{"a": 7}' \%>\%  do(.a + 1)
'[8,3,null,6]' \%>\% sortj

x <- '[{"message": "hello", "name": "jenn"},
  {"message": "world", "name": "beth"}]'
jq(index(x))

jq('{"a": 7, "b": 4}', 'keys')
jq('[8,3,null,6]', 'sort')

# many json inputs
jq(c("[123, 456]", "[77, 88, 99]", "[41]"), ".[]")
# Stream from connection
tmp <- tempfile()
writeLines(c("[123, 456]", "[77, 88, 99]", "[41]"), tmp)
jq(file(tmp), ".[]")

\dontrun{
# from a url
x <- 'http://jeroen.github.io/data/diamonds.json'
jq(url(x), ".[]")

# from a file
file <- file.path(tempdir(), "diamonds_nd.json")
download.file(x, destfile = file)
jq(file(file), ".carat")
jq(file(file), "select(.carat > 1.5)")
jq(file(file), 'select(.carat > 4 and .cut == "Fair")')
}
}
\seealso{
\code{\link{peek}}
}
