% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.R
\name{jq_flags}
\alias{flags}
\alias{jq_flags}
\title{Flags for use with jq}
\usage{
jq_flags(pretty = FALSE, ascii = FALSE, color = FALSE, sorted = FALSE)

flags(.data, pretty = FALSE, ascii = FALSE, color = FALSE,
  sorted = FALSE)
}
\arguments{
\item{pretty}{Pretty print the json (different to jsonlite's
pretty printing).}

\item{ascii}{Force jq to produce pure ASCII output with non-ASCII
characters replaced by equivalent escape sequences.}

\item{color}{Add ANSI escape sequences for coloured output}

\item{sorted}{Output fields of each object with keys in sorted order}

\item{.data}{A \code{jqr} object.}
}
\description{
The \code{flags} function is provided for the high-level DSL
approach, whereas the \code{jq_flags} function is used to provide
the low-level \code{jq} with the appropriate flags.
}
\examples{
'{"a": 7, "z":0, "b": 4}' \%>\% flags(sorted = TRUE)
'{"a": 7, "z":0, "b": 4}' \%>\% dot \%>\% flags(sorted = TRUE)
jq('{"a": 7, "z":0, "b": 4}', ".") \%>\% flags(sorted = TRUE)
jq('{"a": 7, "z":0, "b": 4}', ".", flags = jq_flags(sorted = TRUE))
}

