% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estat.R
\name{estat}
\alias{estat}
\title{Access 'e-Stat' data}
\usage{
estat(
  appId,
  statsDataId,
  lang = c("J", "E"),
  query = list(),
  path = "rest/3.0/app/json/"
)
}
\arguments{
\item{appId}{An 'appId' of 'e-Stat' API.}

\item{statsDataId}{A statistical data ID on 'e-Stat'.}

\item{lang}{A language, Japanese (\code{"J"}) or English (\code{"E"}).}

\item{query}{A list of additional queries.}

\item{path}{An e-Stat API path.}
}
\value{
A \code{estat} object.
}
\description{
The \code{estat()} gets the meta-information of a statistical table by using \code{getMetaInfo} of the 'e-Stat' API,
and returns an \code{estat} object that allows editing of meta-information by \code{dplyr::filter()} and \code{dplyr::select()}.
}
\examples{
\dontrun{
estat("Your appId", "https://www.e-stat.go.jp/dbview?sid=0003433219")
}

}
\seealso{
\url{https://www.e-stat.go.jp}

\url{https://www.e-stat.go.jp/en}
}
