% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_magnitude.R
\name{set_magnitude}
\alias{set_magnitude}
\title{Define magnitude, magnitude label and denominator for a vector of numeric
values.}
\usage{
set_magnitude(x, mag = NULL, label_thousands = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{[num] numeric vector}

\item{mag}{[chr: default NULL c(NULL, "T", "B", "M")] NULL (auto-detect),
otherwise user-override (not recommended) - (M)illions or (B)illions or
(T)housands (thousands are not Lancet-valid)}

\item{label_thousands}{[lgl: default FALSE] allow (T)housands magnitude?  Not
Lancet-valid.}

\item{verbose}{[lgl: default TRUE] warn if label_thousands is TRUE}
}
\value{
[data.frame] with vector elements: mag, mag_label, and denom Each vector
  element has one item per length(x)
}
\description{
Support function used on _central_ (e.g. mean) values for later formatting
functions.
}
\details{
'Thousands' label is not a Lancet-valid, which uses ddd<narrow-space>ddd
format.  See `fround_count()` for details.
}
\examples{
set_magnitude(c(1e-6, 1, 1e3, 1e6, 1e9))
}
\seealso{
[fround_count()]

Other magnitudes: 
\code{\link{fmt_magnitude}()}
}
\concept{magnitudes}
