% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{joinet}
\alias{joinet}
\title{Multivariate Elastic Net Regression}
\usage{
joinet(
  Y,
  X,
  family = "gaussian",
  nfolds = 10,
  foldid = NULL,
  type.measure = "deviance",
  alpha.base = 1,
  alpha.meta = 1,
  weight = NULL,
  sign = NULL,
  ...
)
}
\arguments{
\item{Y}{outputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{q} columns (outputs)}

\item{X}{inputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (inputs)}

\item{family}{distribution\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"gaussian"}, \code{"binomial"} or \code{"poisson"}}

\item{nfolds}{number of folds}

\item{foldid}{fold identifiers\strong{:}
vector of length \eqn{n} with entries between \eqn{1} and \code{nfolds};
or \code{NULL} (balance)}

\item{type.measure}{loss function\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"deviance"}, \code{"class"}, \code{"mse"} or \code{"mae"}
(see \code{\link[glmnet]{cv.glmnet}})}

\item{alpha.base}{elastic net mixing parameter for base learners\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{alpha.meta}{elastic net mixing parameter for meta learners\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{weight}{input-output relations\strong{:}
matrix with \eqn{p} rows (inputs) and \eqn{q} columns (outputs)
with entries \eqn{0} (exclude) and \eqn{1} (include),
or \code{NULL} (see details)}

\item{sign}{output-output relations\strong{:}
matrix with \eqn{q} rows ("meta-inputs") and \eqn{q} columns (outputs), 
with entries \eqn{-1} (negative), \eqn{0} (none),
\eqn{1} (positive) and \eqn{NA} (any),
or \code{NULL} (see details)}

\item{...}{further arguments passed to \code{\link[glmnet]{glmnet}}}
}
\value{
This function returns an object of class \code{joinet}.
Available methods include
\code{\link[=predict.joinet]{predict}},
\code{\link[=coef.joinet]{coef}},
and \code{\link[=weights.joinet]{weights}}.
The slots \code{base} and \code{meta} each contain
\eqn{q} \code{\link[glmnet]{cv.glmnet}}-like objects.
}
\description{
Implements multivariate elastic net regression.
}
\details{
\strong{input-output relations:}
In this matrix with \eqn{p} rows and \eqn{q} columns,
the entry in the \eqn{j}th row and the \eqn{k}th column
indicates whether the \eqn{j}th input may be used for 
modelling the \eqn{k}th output
(where \eqn{0} means "exclude" and
\eqn{1} means "include").
By default (\code{sign=NULL}),
all entries are set to \eqn{1}.

\strong{output-output relations:}
In this matrix with \eqn{q} rows and \eqn{q} columns,
the entry in the \eqn{l}th row and the \eqn{k}th column
indicates how the \eqn{l}th output may be used for
modelling the \eqn{k}th output
(where \eqn{-1} means negative effect,
\eqn{0} means no effect,
\eqn{1} means positive effect,
and \eqn{NA} means any effect).

There are three short-cuts for filling up this matrix:
(1) \code{sign=1} sets all entries to \eqn{1} (non-negativity constraints).
This is useful if all pairs of outcomes
are assumed to be \emph{positively} correlated
(potentially after changing the sign of some outcomes).
(2) \code{code=NA} sets all diagonal entries to \eqn{1}
and all off-diagonal entries to \code{NA} (no constraints).
(3) \code{sign=NULL} uses Spearman correlation to determine the entries,
with \eqn{-1} for significant negative, \eqn{0} for insignificant,
\eqn{1} for significant positive correlations.

\strong{elastic net:}
\code{alpha.base} controls input-output effects,
\code{alpha.meta} controls output-output effects;
lasso renders sparse models (\code{alpha}\eqn{=1}),
ridge renders dense models (\code{alpha}\eqn{=0})
}
\examples{
\dontshow{
if(!grepl('SunOS',Sys.info()['sysname'])){
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)}}
\dontrun{
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)}

\dontrun{
browseVignettes("joinet") # further examples}

}
\references{
Armin Rauschenberger, Enrico Glaab (2021)
"Predicting correlated outcomes from molecular data"
\emph{Manuscript in preparation}.
}
\seealso{
\code{\link{cv.joinet}}, vignette
}
