
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
contTablesOptions <- R6::R6Class(
    "contTablesOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            rows = NULL,
            cols = NULL,
            counts = NULL,
            layers = NULL,
            chiSq = TRUE,
            chiSqCorr = FALSE,
            likeRat = FALSE,
            contCoef = FALSE,
            phiCra = FALSE,
            logOdds = FALSE,
            ciWidth = 95,
            gamma = FALSE,
            taub = FALSE,
            exp = FALSE,
            pcRow = FALSE,
            pcCol = FALSE,
            pcTot = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='contTables',
                requiresData=TRUE,
                ...)
        
            private$..rows <- jmvcore::OptionVariable$new(
                "rows",
                rows,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..cols <- jmvcore::OptionVariable$new(
                "cols",
                cols,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..counts <- jmvcore::OptionVariable$new(
                "counts",
                counts,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..layers <- jmvcore::OptionVariables$new(
                "layers",
                layers,
                default=NULL)
            private$..chiSq <- jmvcore::OptionBool$new(
                "chiSq",
                chiSq,
                default=TRUE)
            private$..chiSqCorr <- jmvcore::OptionBool$new(
                "chiSqCorr",
                chiSqCorr,
                default=FALSE)
            private$..likeRat <- jmvcore::OptionBool$new(
                "likeRat",
                likeRat,
                default=FALSE)
            private$..contCoef <- jmvcore::OptionBool$new(
                "contCoef",
                contCoef,
                default=FALSE)
            private$..phiCra <- jmvcore::OptionBool$new(
                "phiCra",
                phiCra,
                default=FALSE)
            private$..logOdds <- jmvcore::OptionBool$new(
                "logOdds",
                logOdds,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..gamma <- jmvcore::OptionBool$new(
                "gamma",
                gamma,
                default=FALSE)
            private$..taub <- jmvcore::OptionBool$new(
                "taub",
                taub,
                default=FALSE)
            private$..exp <- jmvcore::OptionBool$new(
                "exp",
                exp,
                default=FALSE)
            private$..pcRow <- jmvcore::OptionBool$new(
                "pcRow",
                pcRow,
                default=FALSE)
            private$..pcCol <- jmvcore::OptionBool$new(
                "pcCol",
                pcCol,
                default=FALSE)
            private$..pcTot <- jmvcore::OptionBool$new(
                "pcTot",
                pcTot,
                default=FALSE)
        
            self$.addOption(private$..rows)
            self$.addOption(private$..cols)
            self$.addOption(private$..counts)
            self$.addOption(private$..layers)
            self$.addOption(private$..chiSq)
            self$.addOption(private$..chiSqCorr)
            self$.addOption(private$..likeRat)
            self$.addOption(private$..contCoef)
            self$.addOption(private$..phiCra)
            self$.addOption(private$..logOdds)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..gamma)
            self$.addOption(private$..taub)
            self$.addOption(private$..exp)
            self$.addOption(private$..pcRow)
            self$.addOption(private$..pcCol)
            self$.addOption(private$..pcTot)
        }),
    active = list(
        rows = function() private$..rows$value,
        cols = function() private$..cols$value,
        counts = function() private$..counts$value,
        layers = function() private$..layers$value,
        chiSq = function() private$..chiSq$value,
        chiSqCorr = function() private$..chiSqCorr$value,
        likeRat = function() private$..likeRat$value,
        contCoef = function() private$..contCoef$value,
        phiCra = function() private$..phiCra$value,
        logOdds = function() private$..logOdds$value,
        ciWidth = function() private$..ciWidth$value,
        gamma = function() private$..gamma$value,
        taub = function() private$..taub$value,
        exp = function() private$..exp$value,
        pcRow = function() private$..pcRow$value,
        pcCol = function() private$..pcCol$value,
        pcTot = function() private$..pcTot$value),
    private = list(
        ..rows = NA,
        ..cols = NA,
        ..counts = NA,
        ..layers = NA,
        ..chiSq = NA,
        ..chiSqCorr = NA,
        ..likeRat = NA,
        ..contCoef = NA,
        ..phiCra = NA,
        ..logOdds = NA,
        ..ciWidth = NA,
        ..gamma = NA,
        ..taub = NA,
        ..exp = NA,
        ..pcRow = NA,
        ..pcCol = NA,
        ..pcTot = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
contTablesResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        freqs = function() private$..freqs,
        chiSq = function() private$..chiSq,
        odds = function() private$..odds,
        nom = function() private$..nom,
        gamma = function() private$..gamma,
        taub = function() private$..taub),
    private = list(
        ..freqs = NA,
        ..chiSq = NA,
        ..odds = NA,
        ..nom = NA,
        ..gamma = NA,
        ..taub = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Contingency Tables")
            private$..freqs <- jmvcore::Table$new(
                options=options,
                name="freqs",
                title="Contingency Tables",
                columns=list(),
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"))
            private$..chiSq <- jmvcore::Table$new(
                options=options,
                name="chiSq",
                title="\u03C7\u00B2 Tests",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(`name`="test[chiSq]", `title`="", `type`="text", `content`="\u03C7\u00B2", `visible`="(chiSq)"),
                    list(`name`="value[chiSq]", `title`="Value", `visible`="(chiSq)"),
                    list(`name`="df[chiSq]", `title`="df", `type`="integer", `visible`="(chiSq)"),
                    list(`name`="p[chiSq]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(chiSq)"),
                    list(`name`="test[chiSqCorr]", `title`="", `type`="text", `content`="\u03C7\u00B2 continuity correction", `visible`="(chiSqCorr)"),
                    list(`name`="value[chiSqCorr]", `title`="Value", `visible`="(chiSqCorr)"),
                    list(`name`="df[chiSqCorr]", `title`="df", `type`="integer", `visible`="(chiSqCorr)"),
                    list(`name`="p[chiSqCorr]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(chiSqCorr)"),
                    list(`name`="test[likeRat]", `title`="", `type`="text", `content`="Likelihood ratio", `visible`="(likeRat)"),
                    list(`name`="value[likeRat]", `title`="Value", `visible`="(likeRat)"),
                    list(`name`="df[likeRat]", `title`="df", `type`="integer", `visible`="(likeRat)"),
                    list(`name`="p[likeRat]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(likeRat)"),
                    list(`name`="test[N]", `title`="", `type`="text", `content`="N"),
                    list(`name`="value[N]", `title`="Value", `type`="integer")))
            private$..odds <- jmvcore::Table$new(
                options=options,
                name="odds",
                title="Log Odds Ratio",
                visible="(logOdds)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers",
                    "ciWidth"),
                columns=list(
                    list(`name`="t[lo]", `title`="", `type`="text", `content`="Log odds ratio"),
                    list(`name`="v[lo]", `title`="Value"),
                    list(`name`="cil[lo]", `title`="Lower", `superTitle`="Confidence Intervals"),
                    list(`name`="ciu[lo]", `title`="Upper", `superTitle`="Confidence Intervals"),
                    list(`name`="t[f]", `title`="", `type`="text", `content`="Fisher's exact test"),
                    list(`name`="v[f]", `title`="Value"),
                    list(`name`="cil[f]", `title`="Lower", `superTitle`="Confidence Intervals"),
                    list(`name`="ciu[f]", `title`="Upper", `superTitle`="Confidence Intervals")))
            private$..nom <- jmvcore::Table$new(
                options=options,
                name="nom",
                title="Nominal",
                visible="(contCoef || phiCra)",
                columns=list(
                    list(`name`="t[cont]", `title`="", `type`="text", `content`="Contingency coefficient", `visible`="(contCoef)"),
                    list(`name`="v[cont]", `title`="Value", `visible`="(contCoef)"),
                    list(`name`="t[phi]", `title`="", `type`="text", `content`="Phi-coefficient", `visible`="(phiCra)"),
                    list(`name`="v[phi]", `title`="Value", `visible`="(phiCra)"),
                    list(`name`="t[cra]", `title`="", `type`="text", `content`="Cramer's V", `visible`="(phiCra)"),
                    list(`name`="v[cra]", `title`="Value", `visible`="(phiCra)")))
            private$..gamma <- jmvcore::Table$new(
                options=options,
                name="gamma",
                title="Gamma",
                visible="(gamma)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(`name`="gamma", `title`="Gamma"),
                    list(`name`="se", `title`="Standard Error"),
                    list(`name`="cil", `title`="Lower", `superTitle`="Confidence Intervals"),
                    list(`name`="ciu", `title`="Upper", `superTitle`="Confidence Intervals")))
            private$..taub <- jmvcore::Table$new(
                options=options,
                name="taub",
                title="Kendall's Tau-b",
                visible="(taub)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(`name`="taub", `title`="Kendall's Tau-B"),
                    list(`name`="t", `title`="t"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
            self$add(private$..freqs)
            self$add(private$..chiSq)
            self$add(private$..odds)
            self$add(private$..nom)
            self$add(private$..gamma)
            self$add(private$..taub)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
contTablesBase <- R6::R6Class(
    "contTablesBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'contTables',
                version = c(1,0,0),
                options = options,
                results = contTablesResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Contingency Tables
#'
#' chi² test of association
#'
#' @examples
#' \dontrun{
#' contTables(data, rows='x', cols='y')
#' }
#' @param data the data as a data frame
#' @param rows a string naming the variable to use as the rows in the 
#'   contingency table 
#' @param cols a string naming the variable to use as the columns in the 
#'   contingency table 
#' @param counts a string naming the variable to use as counts, or NULL if 
#'   each row represents a single observation 
#' @param layers a character vector naming variables to split the contingency 
#'   table across 
#' @param chiSq \code{TRUE} (default) or \code{FALSE}, provide chi² 
#' @param chiSqCorr \code{TRUE} or \code{FALSE} (default), provide chi² with 
#'   continuity correction 
#' @param likeRat \code{TRUE} or \code{FALSE} (default), provide the 
#'   likelihood ratio 
#' @param contCoef \code{TRUE} or \code{FALSE} (default), provide the 
#'   contingency coefficient 
#' @param phiCra \code{TRUE} or \code{FALSE} (default), provide Phi and 
#'   Cramer's V 
#' @param logOdds \code{TRUE} or \code{FALSE} (default), provide the log odds 
#'   ratio (only available for 2x2 tables) 
#' @param ciWidth a number between 50 and 99.9 (default: 95), width of the 
#'   confidence intervals to provide 
#' @param gamma \code{TRUE} or \code{FALSE} (default), provide gamma 
#' @param taub \code{TRUE} or \code{FALSE} (default), provide Kendall's tau-b 
#' @param exp \code{TRUE} or \code{FALSE} (default), provide the expected 
#'   counts 
#' @param pcRow \code{TRUE} or \code{FALSE} (default), provide row percentages 
#' @param pcCol \code{TRUE} or \code{FALSE} (default), provide column 
#'   percentages 
#' @param pcTot \code{TRUE} or \code{FALSE} (default), provide total 
#'   percentages 
#' @export
contTables <- function(
    data,
    rows,
    cols,
    counts = NULL,
    layers = NULL,
    chiSq = TRUE,
    chiSqCorr = FALSE,
    likeRat = FALSE,
    contCoef = FALSE,
    phiCra = FALSE,
    logOdds = FALSE,
    ciWidth = 95,
    gamma = FALSE,
    taub = FALSE,
    exp = FALSE,
    pcRow = FALSE,
    pcCol = FALSE,
    pcTot = FALSE) {

    options <- contTablesOptions$new(
        rows = rows,
        cols = cols,
        counts = counts,
        layers = layers,
        chiSq = chiSq,
        chiSqCorr = chiSqCorr,
        likeRat = likeRat,
        contCoef = contCoef,
        phiCra = phiCra,
        logOdds = logOdds,
        ciWidth = ciWidth,
        gamma = gamma,
        taub = taub,
        exp = exp,
        pcRow = pcRow,
        pcCol = pcCol,
        pcTot = pcTot)

    results <- contTablesResults$new(
        options = options)

    analysis <- contTablesClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis$results
}
