% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jlctree.control.R
\name{jlctree.control}
\alias{jlctree.control}
\title{Sets the control parameters for \code{jlctree}.}
\usage{
jlctree.control(test.stat = "lrt", stop.thre = 3.84, stable = TRUE,
  maxng = 6, min.nevents = 5, split.add = 20, cov.max = 1e+05,
  fity = TRUE, fits = TRUE, ...)
}
\arguments{
\item{test.stat}{test statistic to use, ``lrt'' for likelihood ratio test,
and ``wald'' for Wald test. Default is ``lrt''.}

\item{stop.thre}{stops splitting if current node has test statistic less than \code{stop.thre}. 
Default is 3.84.}

\item{stable}{if TRUE, check the variance of the estimated coefficients in survival models fit at tree nodes.
If a node has variance larger than \code{cov.max}, the splitting function
will not consider splits leading to that node. Default is TRUE.}

\item{maxng}{maximum number of terminal nodes. Default is 6.}

\item{min.nevents}{minimum number of events in any terminal node.
By default, this parameter is set to the number of covariates 
used in the survival model.}

\item{split.add}{when computing the difference between parent node's test statistic
and sum of child nodes' test statistics, add \code{split.add} to the difference. 
When \code{split.add} > 0, tree may still split even if current split 
leads to negative improvement. 
Set \code{split.add} to a large positive value for the purpose of greedy splitting. 
Default is 20.}

\item{cov.max}{upper bound on the variance of the estimated coefficients 
in survival models at tree nodes. Default is 1e5.}

\item{fity}{if TRUE, once a tree is constructed, fit a linear mixed-effects model using 
tree nodes as group indicators. Default is TRUE.}

\item{fits}{if TRUE, once a tree is constructed, fit survival models using tree nodes
as group indicators. Default is TRUE.}

\item{...}{further arguments to pass to or from other methods.}
}
\value{
A list of all these parameters.
}
\description{
Sets the control parameters for \code{jlctree}.
}
\seealso{
\code{\link{jlctree},\link{jlctree-package}}
}
