% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ncdfcwt.R
\name{create_ncdfcwt}
\alias{create_ncdfcwt}
\title{create_ncdfcwt}
\usage{
create_ncdfcwt(cwt_out, times, centralp, onefile = TRUE, path = NULL)
}
\arguments{
\item{cwt_out}{List with a list for each grid point that contains two objects: CWT and indices.}

\item{times}{Numeric with the dates.}

\item{centralp}{Numeric with the centralp obtained from the main program.}

\item{onefile}{Logical. If TRUE one single output file with all WT is created, if FALSE
one file per type is created.}

\item{path}{Path name to create the output file.}
}
\value{
A netcdf file with all weather types or one file per type.
}
\description{
Converts 3D arrays with daily frequencies of weather types to NETCDF files.
}
\examples{
\donttest{
# This is a long running example
cwtGlobal <- extended_jc(press$msl, press$loni, press$lati, press$dates, gale=FALSE, num_cores=2)
# Create ncdf file (one file with all types)
create_ncdfcwt(cwtGlobal, press$dates, cwtGlobal$centralp, onefile = TRUE, path = NULL)
}

}
\seealso{
\code{\link{createindex_ncdf}\link{extended_jc}}
}
