% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{diabetes_eyes}
\alias{diabetes_eyes}
\title{Individual Participant Data: Diabetic Eyes Data}
\format{
A dataframe with 270 columns and 97 rows, where each row represents a patient. The columns include:
   \describe{
    \item{pat}{Patient ID.}
    \item{diabetes_type}{Indicator for diabetes (2 = diabetic (type 2), 0 = healthy).}
    \item{sex}{Gender of the patient (1 = Male, 2 = Female).}
    \item{age}{Age of the patient (years).}
    \item{smoker}{Smoking status (1 = Smoker, 0 = Non-smoker).}
    \item{weight}{Weight of the patient (kg).}
    \item{height}{Height of the patient (m).}
    \item{BMI}{Body Mass Index}
    \item{VISUAL_ACUITY_RIGHT_EYE}{Visual acuity for the right eye.}
    \item{VISUAL_ACUITY_LEFT_EYE}{Visual acuity for the left eye.}
    \item{CONTRAST_SENSITIVITY_RIGHT_EYE}{Measure of contrast sensitivity for the left eye.}
    \item{CONTRAST_SENSITIVITY_LEFT_EYE}{Measure of contrast sensitivity for the left eye.}
    \item{R_PAP_RNFL_N}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Nasal Parafovea}
    \item{R_PAP_RNFL_NI}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Nasal Inferior Parafovea}
    \item{R_PAP_RNFL_TI}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Temporal Inferior Parafovea}
    \item{R_PAP_RNFL_T}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Temporal Parafovea}
    \item{R_PAP_RNFL_TS}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Temporal Superior Parafovea}
    \item{R_PAP_RNFL_G}{Measurement of the right eye, Papilla, Retinal Nerve Fiber Layer, Global Layer}
    \item{L_PAP_RNFL_NS}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Nasal Superior Parafovea}
    \item{L_PAP_RNFL_N}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Nasal Parafovea}
    \item{L_PAP_RNFL_NI}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Nasal Inferior Parafovea}
    \item{L_PAP_RNFL_TI}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Temporal Inferior Parafovea}
    \item{L_PAP_RNFL_T}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Temporal Parafovea}
    \item{L_PAP_RNFL_TS}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Temporal Superior Parafovea}
    \item{L_PAP_RNFL_G}{Measurement of the left eye, Papilla, Retinal Nerve Fiber Layer, Global Layer}
    \item{R_PAP_FULL_NS}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Nasal Superior Parafovea}
    \item{R_PAP_FULL_N}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Nasal Parafovea}
    \item{R_PAP_FULL_NI}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Nasal Inferior Parafovea}
    \item{R_PAP_FULL_TI}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Temporal Inferior Parafovea}
    \item{R_PAP_FULL_T}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Temporal Parafovea}
    \item{R_PAP_FULL_TS}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Temporal Superior Parafovea}
    \item{R_PAP_FULL_G}{Measurement of the right eye, Papilla, Complete Retinal Thickness, Global Layer}
    \item{L_PAP_FULL_NS}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Nasal Superior Parafovea}
    \item{L_PAP_FULL_N}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Nasal Parafovea}
    \item{L_PAP_FULL_NI}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Nasal Inferior Parafovea}
    \item{L_PAP_FULL_TI}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Temporal Inferior Parafovea}
    \item{L_PAP_FULL_T}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Temporal Parafovea}
    \item{L_PAP_FULL_TS}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Temporal Superior Parafovea}
    \item{L_PAP_FULL_G}{Measurement of the left eye, Papilla, Complete Retinal Thickness, Global Layer}
    \item{R_PAP_GCLIPL_NS}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Superior Parafovea}
    \item{R_PAP_GCLIPL_N}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Parafovea}
    \item{R_PAP_GCLIPL_NI}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Inferior Parafovea}
    \item{R_PAP_GCLIPL_TI}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Inferior Parafovea}
    \item{R_PAP_GCLIPL_T}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Parafovea}
    \item{R_PAP_GCLIPL_TS}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Superior Parafovea}
    \item{R_PAP_GCLIPL_G}{Measurement of the right eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Global Layer}
    \item{L_PAP_GCLIPL_NS}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Superior Parafovea}
    \item{L_PAP_GCLIPL_N}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Parafovea}
    \item{L_PAP_GCLIPL_NI}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Inferior Parafovea}
    \item{L_PAP_GCLIPL_TI}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Inferior Parafovea}
    \item{L_PAP_GCLIPL_T}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Parafovea}
    \item{L_PAP_GCLIPL_TS}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Temporal Superior Parafovea}
    \item{L_PAP_GCLIPL_G}{Measurement of the left eye, Papilla, Ganglion Cell Layer and Inner Plexiform Layer combined, Global Layer}
    \item{R_PAP_INLOPL_NS}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Superior Parafovea}
    \item{R_PAP_INLOPL_N}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Parafovea}
    \item{R_PAP_INLOPL_NI}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Inferior Parafovea}
    \item{R_PAP_INLOPL_TI}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Inferior Parafovea}
    \item{R_INLOPL_T}{Measurement of the right eye, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Parafovea}
    \item{R_PAP_INLOPL_TS}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Superior Parafovea}
    \item{R_PAP_INLOPL_G}{Measurement of the right eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Global Layer}
    \item{L_PAP_INLOPL_NS}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Superior Parafovea}
    \item{L_PAP_INLOPL_N}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Parafovea}
    \item{L_PAP_INLOPL_NI}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Inferior Parafovea}
    \item{L_PAP_INLOPL_TI}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Inferior Parafovea}
    \item{L_PAP_INLOPL_T}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Parafovea}
    \item{L_PAP_INLOPL_TS}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Temporal Superior Parafovea}
    \item{L_PAP_INLOPL_G}{Measurement of the left eye, Papilla, Inner Nuclear Layer and Outer Plexiform Layer combined, Global Layer}
    \item{R_PAP_ONLFIS_NS}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Superior Parafovea}
    \item{R_PAP_ONLFIS_N}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Parafovea}
    \item{R_PAP_ONLFIS_NI}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Inferior Parafovea}
    \item{R_PAP_ONLFIS_TI}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Inferior Parafovea}
    \item{R_PAP_ONLFIS_T}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Parafovea}
    \item{R_PAP_ONLFIS_TS}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Superior Parafovea}
    \item{R_PAP_ONLFIS_G}{Measurement of the right eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Global Layer}
    \item{L_PAP_ONLFIS_NS}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Superior Parafovea}
    \item{L_PAP_ONLFIS_N}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Parafovea}
    \item{L_PAP_ONLFIS_NI}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Inferior Parafovea}
    \item{L_PAP_ONLFIS_TI}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Inferior Parafovea}
    \item{L_PAP_ONLFIS_T}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Parafovea}
    \item{L_PAP_ONLFIS_TS}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Temporal Superior Parafovea}
    \item{L_PAP_ONLFIS_G}{Measurement of the left eye, Papilla, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Global Layer}
    \item{R_PAP_FBBM_NS}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Superior Parafovea}
    \item{R_PAP_FBBM_N}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Parafovea}
    \item{R_PAP_FBBM_NI}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Inferior Parafovea}
    \item{R_PAP_FBBM_TI}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Inferior Parafovea}
    \item{R_PAP_FBBM_T}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Parafovea}
    \item{R_PAP_FBBM_TS}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Superior Parafovea}
    \item{R_PAP_FBBM_G}{Measurement of the right eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Global Layer}
    \item{L_PAP_FBBM_NS}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Superior Parafovea}
    \item{L_PAP_FBBM_N}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Parafovea}
    \item{L_PAP_FBBM_NI}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Inferior Parafovea}
    \item{L_PAP_FBBM_TI}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Inferior Parafovea}
    \item{L_PAP_FBBM_T}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Parafovea}
    \item{L_PAP_FBBM_TS}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Temporal Superior Parafovea}
    \item{L_PAP_FBBM_G}{Measurement of the left eye, Papilla, Photoreceptor Fiber Layer and Basal Membrane combined, Global Layer}
    \item{M_R_MAC_FULL_N2}{Manual measurement of the right eye, Macula, Complete Retinal Thickness, Nasal Outer Parafovea}
    \item{M_R_MAC_GCLIPL_N2}{Manual measurement of the right eye, Macula, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Outer Parafovea}
    \item{M_R_MAC_INLOPL_N2}{Manual measurement of the right eye, Macula, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Outer Parafovea}
    \item{M_R_MAC_ONLFIS_N2}{Manual measurement of the right eye, Macula, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Outer Parafovea}
    \item{M_R_MAC_FBBM_N2}{Manual measurement of the right eye, Macula, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Outer Parafovea}
    \item{M_R_MAC_RNFL_N2}{Manual measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Nasal Outer Parafovea}
    \item{M_L_MAC_FULL_N2}{Manual measurement of the left eye, Macula, Complete Retinal Thickness, Nasal Outer Parafovea}
    \item{M_L_MAC_GCLIPL_N2}{Manual measurement of the left eye, Macula, Ganglion Cell Layer and Inner Plexiform Layer combined, Nasal Outer Parafovea}
    \item{M_L_MAC_INLOPL_N2}{Manual measurement of the left eye, Macula, Inner Nuclear Layer and Outer Plexiform Layer combined, Nasal Outer Parafovea}
    \item{M_L_MAC_ONLFIS_N2}{Manual measurement of the left eye, Macula, Outer Nuclear Layer and Photoreceptor Inner Segment Layer combined, Nasal Outer Parafovea}
    \item{M_L_MAC_FBBM_N2}{Manual measurement of the left eye, Macula, Photoreceptor Fiber Layer and Basal Membrane combined, Nasal Outer Parafovea}
    \item{M_L_MAC_RNFL_N2}{Manual measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Nasal Outer Parafovea}
    \item{R_MAC_FULL_S1}{Measurement of the right eye, Macula, Complete Retinal Thickness, Superior Inner Parafovea}
    \item{R_MAC_FULL_S2}{Measurement of the right eye, Macula, Complete Retinal Thickness, Superior Outer Parafovea}
    \item{R_MAC_FULL_N1}{Measurement of the right eye, Macula, Complete Retinal Thickness, Nasal Inner Parafovea}
    \item{R_MAC_FULL_N2}{Measurement of the right eye, Macula, Complete Retinal Thickness, Nasal Outer Parafovea}
    \item{R_MAC_FULL_I1}{Measurement of the right eye, Macula, Complete Retinal Thickness, Inferior Inner Parafovea}
    \item{R_MAC_FULL_I2}{Measurement of the right eye, Macula, Complete Retinal Thickness, Inferior Outer Parafovea}
    \item{R_MAC_FULL_T1}{Measurement of the right eye, Macula, Complete Retinal Thickness, Temporal Inner Parafovea}
    \item{R_MAC_FULL_T2}{Measurement of the right eye, Macula, Complete Retinal Thickness, Temporal Outer Parafovea}
    \item{R_MAC_FULL_C}{Measurement of the right eye, Macula, Complete Retinal Thickness, Center Fovea}
    \item{R_MAC_RNFL_S1}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Superior Inner Parafovea}
    \item{R_MAC_RNFL_S2}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Superior Outer Parafovea}
    \item{R_MAC_RNFL_N1}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Nasal Inner Parafovea}
    \item{R_MAC_RNFL_N2}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Nasal Outer Parafovea}
    \item{R_MAC_RNFL_I1}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Inferior Inner Parafovea}
    \item{R_MAC_RNFL_I2}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Inferior Outer Parafovea}
    \item{R_MAC_RNFL_T1}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Temporal Inner Parafovea}
    \item{R_MAC_RNFL_T2}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Temporal Outer Parafovea}
    \item{R_MAC_RNFL_C}{Measurement of the right eye, Macula, Retinal Nerve Fiber Layer, Center Fovea}
    \item{R_MAC_GCL_S1}{Measurement of the right eye, Macula, Ganglion Cell Layer, Superior Inner Parafovea}
    \item{R_MAC_GCL_S2}{Measurement of the right eye, Macula, Ganglion Cell Layer, Superior Outer Parafovea}
    \item{R_MAC_GCL_N1}{Measurement of the right eye, Macula, Ganglion Cell Layer, Nasal Inner Parafovea}
    \item{R_MAC_GCL_N2}{Measurement of the right eye, Macula, Ganglion Cell Layer, Nasal Outer Parafovea}
    \item{R_MAC_GCL_I1}{Measurement of the right eye, Macula, Ganglion Cell Layer, Inferior Inner Parafovea}
    \item{R_MAC_GCL_I2}{Measurement of the right eye, Macula, Ganglion Cell Layer, Inferior Outer Parafovea}
    \item{R_MAC_GCL_T1}{Measurement of the right eye, Macula, Ganglion Cell Layer, Temporal Inner Parafovea}
    \item{R_MAC_GCL_T2}{Measurement of the right eye, Macula, Ganglion Cell Layer, Temporal Outer Parafovea}
    \item{R_MAC_GCL_C}{Measurement of the right eye, Macula, Ganglion Cell Layer, Center Fovea}
    \item{R_MAC_IPL_S1}{Measurement of the right eye, Macula, Inner Plexiform Layer, Superior Inner Parafovea}
    \item{R_MAC_IPL_S2}{Measurement of the right eye, Macula, Inner Plexiform Layer, Superior Outer Parafovea}
    \item{R_MAC_IPL_N1}{Measurement of the right eye, Macula, Inner Plexiform Layer, Nasal Inner Parafovea}
    \item{R_MAC_IPL_N2}{Measurement of the right eye, Macula, Inner Plexiform Layer, Nasal Outer Parafovea}
    \item{R_MAC_IPL_I1}{Measurement of the right eye, Macula, Inner Plexiform Layer, Inferior Inner Parafovea}
    \item{R_MAC_IPL_I2}{Measurement of the right eye, Macula, Inner Plexiform Layer, Inferior Outer Parafovea}
    \item{R_MAC_IPL_T1}{Measurement of the right eye, Macula, Inner Plexiform Layer, Temporal Inner Parafovea}
    \item{R_MAC_IPL_T2}{Measurement of the right eye, Macula, Inner Plexiform Layer, Temporal Outer Parafovea}
    \item{R_MAC_IPL_C}{Measurement of the right eye, Macula, Inner Plexiform Layer, Center Fovea}
    \item{R_MAC_INL_S1}{Measurement of the right eye, Macula, Inner Nuclear Layer, Superior Inner Parafovea}
    \item{R_MAC_INL_S2}{Measurement of the right eye, Macula, Inner Nuclear Layer, Superior Outer Parafovea}
    \item{R_MAC_INL_N1}{Measurement of the right eye, Macula, Inner Nuclear Layer, Nasal Inner Parafovea}
    \item{R_MAC_INL_N2}{Measurement of the right eye, Macula, Inner Nuclear Layer, Nasal Outer Parafovea}
    \item{R_MAC_INL_I1}{Measurement of the right eye, Macula, Inner Nuclear Layer, Inferior Inner Parafovea}
    \item{R_MAC_INL_I2}{Measurement of the right eye, Macula, Inner Nuclear Layer, Inferior Outer Parafovea}
    \item{R_MAC_INL_T1}{Measurement of the right eye, Macula, Inner Nuclear Layer, Temporal Inner Parafovea}
    \item{R_MAC_INL_T2}{Measurement of the right eye, Macula, Inner Nuclear Layer, Temporal Outer Parafovea}
    \item{R_MAC_INL_C}{Measurement of the right eye, Macula, Inner Nuclear Layer, Center Fovea}
    \item{R_MAC_OPL_S1}{Measurement of the right eye, Macula, Outer Plexiform Layer, Superior Inner Parafovea}
    \item{R_MAC_OPL_S2}{Measurement of the right eye, Macula, Outer Plexiform Layer, Superior Outer Parafovea}
    \item{R_MAC_OPL_N1}{Measurement of the right eye, Macula, Outer Plexiform Layer, Nasal Inner Parafovea}
    \item{R_MAC_OPL_N2}{Measurement of the right eye, Macula, Outer Plexiform Layer, Nasal Outer Parafovea}
    \item{R_MAC_OPL_I1}{Measurement of the right eye, Macula, Outer Plexiform Layer, Inferior Inner Parafovea}
    \item{R_MAC_OPL_I2}{Measurement of the right eye, Macula, Outer Plexiform Layer, Inferior Outer Parafovea}
    \item{R_MAC_OPL_T1}{Measurement of the right eye, Macula, Outer Plexiform Layer, Temporal Inner Parafovea}
    \item{R_MAC_OPL_T2}{Measurement of the right eye, Macula, Outer Plexiform Layer, Temporal Outer Parafovea}
    \item{R_MAC_OPL_C}{Measurement of the right eye, Macula, Outer Plexiform Layer, Center Fovea}
    \item{R_MAC_ONL_S1}{Measurement of the right eye, Macula, Outer Nuclear Layer, Superior Inner Parafovea}
    \item{R_MAC_ONL_S2}{Measurement of the right eye, Macula, Outer Nuclear Layer, Superior Outer Parafovea}
    \item{R_MAC_ONL_N1}{Measurement of the right eye, Macula, Outer Nuclear Layer, Nasal Inner Parafovea}
    \item{R_MAC_ONL_N2}{Measurement of the right eye, Macula, Outer Nuclear Layer, Nasal Outer Parafovea}
    \item{R_MAC_ONL_I1}{Measurement of the right eye, Macula, Outer Nuclear Layer, Inferior Inner Parafovea}
    \item{R_MAC_ONL_I2}{Measurement of the right eye, Macula, Outer Nuclear Layer, Inferior Outer Parafovea}
    \item{R_MAC_ONL_T1}{Measurement of the right eye, Macula, Outer Nuclear Layer, Temporal Inner Parafovea}
    \item{R_MAC_ONL_T2}{Measurement of the right eye, Macula, Outer Nuclear Layer, Temporal Outer Parafovea}
    \item{R_MAC_ONL_C}{Measurement of the right eye, Macula, Outer Nuclear Layer, Center Fovea}
    \item{R_MAC_RPE_S1}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Superior Inner Parafovea}
    \item{R_MAC_RPE_S2}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Superior Outer Parafovea}
    \item{R_MAC_RPE_N1}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Nasal Inner Parafovea}
    \item{R_MAC_RPE_N2}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Nasal Outer Parafovea}
    \item{R_MAC_RPE_I1}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Inferior Inner Parafovea}
    \item{R_MAC_RPE_I2}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Inferior Outer Parafovea}
    \item{R_MAC_RPE_T1}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Temporal Inner Parafovea}
    \item{R_MAC_RPE_T2}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Temporal Outer Parafovea}
    \item{R_MAC_RPE_C}{Measurement of the right eye, Macula, Retinal Pigment Epithelium, Center Fovea}
    \item{R_MAC_PHOTO_S1}{Measurement of the right eye, Macula, Unknown Layer, Superior Inner Parafovea}
    \item{R_MAC_PHOTO_S2}{Measurement of the right eye, Macula, Unknown Layer, Superior Outer Parafovea}
    \item{R_MAC_PHOTO_N1}{Measurement of the right eye, Macula, Unknown Layer, Nasal Inner Parafovea}
    \item{R_MAC_PHOTO_N2}{Measurement of the right eye, Macula, Unknown Layer, Nasal Outer Parafovea}
    \item{R_MAC_PHOTO_I1}{Measurement of the right eye, Macula, Unknown Layer, Inferior Inner Parafovea}
    \item{R_MAC_PHOTO_I2}{Measurement of the right eye, Macula, Unknown Layer, Inferior Outer Parafovea}
    \item{R_MAC_PHOTO_T1}{Measurement of the right eye, Macula, Unknown Layer, Temporal Inner Parafovea}
    \item{R_MAC_PHOTO_T2}{Measurement of the right eye, Macula, Unknown Layer, Temporal Outer Parafovea}
    \item{R_MAC_PHOTO_C}{Measurement of the right eye, Macula, Unknown Layer, Center Fovea}
    \item{L_MAC_FULL_S1}{Measurement of the left eye, Macula, Complete Retinal Thickness, Superior Inner Parafovea}
    \item{L_MAC_FULL_S2}{Measurement of the left eye, Macula, Complete Retinal Thickness, Superior Outer Parafovea}
    \item{L_MAC_FULL_N1}{Measurement of the left eye, Macula, Complete Retinal Thickness, Nasal Inner Parafovea}
    \item{L_MAC_FULL_N2}{Measurement of the left eye, Macula, Complete Retinal Thickness, Nasal Outer Parafovea}
    \item{L_MAC_FULL_I1}{Measurement of the left eye, Macula, Complete Retinal Thickness, Inferior Inner Parafovea}
    \item{L_MAC_FULL_I2}{Measurement of the left eye, Macula, Complete Retinal Thickness, Inferior Outer Parafovea}
    \item{L_MAC_FULL_T1}{Measurement of the left eye, Macula, Complete Retinal Thickness, Temporal Inner Parafovea}
    \item{L_MAC_FULL_T2}{Measurement of the left eye, Macula, Complete Retinal Thickness, Temporal Outer Parafovea}
    \item{L_MAC_FULL_C}{Measurement of the left eye, Macula, Complete Retinal Thickness, Center Fovea}
    \item{L_MAC_RNFL_S1}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Superior Inner Parafovea}
    \item{L_MAC_RNFL_S2}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Superior Outer Parafovea}
    \item{L_MAC_RNFL_N1}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Nasal Inner Parafovea}
    \item{L_MAC_RNFL_N2}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Nasal Outer Parafovea}
    \item{L_MAC_RNFL_I1}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Inferior Inner Parafovea}
    \item{L_MAC_RNFL_I2}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Inferior Outer Parafovea}
    \item{L_MAC_RNFL_T1}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Temporal Inner Parafovea}
    \item{L_MAC_RNFL_T2}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Temporal Outer Parafovea}
    \item{L_MAC_RNFL_C}{Measurement of the left eye, Macula, Retinal Nerve Fiber Layer, Center Fovea}
    \item{L_MAC_GCL_S1}{Measurement of the left eye, Macula, Ganglion Cell Layer, Superior Inner Parafovea}
    \item{L_MAC_GCL_S2}{Measurement of the left eye, Macula, Ganglion Cell Layer, Superior Outer Parafovea}
    \item{L_MAC_GCL_N1}{Measurement of the left eye, Macula, Ganglion Cell Layer, Nasal Inner Parafovea}
    \item{L_MAC_GCL_N2}{Measurement of the left eye, Macula, Ganglion Cell Layer, Nasal Outer Parafovea}
    \item{L_MAC_GCL_I1}{Measurement of the left eye, Macula, Ganglion Cell Layer, Inferior Inner Parafovea}
    \item{L_MAC_GCL_I2}{Measurement of the left eye, Macula, Ganglion Cell Layer, Inferior Outer Parafovea}
    \item{L_MAC_GCL_T1}{Measurement of the left eye, Macula, Ganglion Cell Layer, Temporal Inner Parafovea}
    \item{L_MAC_GCL_T2}{Measurement of the left eye, Macula, Ganglion Cell Layer, Temporal Outer Parafovea}
    \item{L_MAC_GCL_C}{Measurement of the left eye, Macula, Ganglion Cell Layer, Center Fovea}
    \item{L_MAC_IPL_S1}{Measurement of the left eye, Macula, Inner Plexiform Layer, Superior Inner Parafovea}
    \item{L_MAC_IPL_S2}{Measurement of the left eye, Macula, Inner Plexiform Layer, Superior Outer Parafovea}
    \item{L_MAC_IPL_N1}{Measurement of the left eye, Macula, Inner Plexiform Layer, Nasal Inner Parafovea}
    \item{L_MAC_IPL_N2}{Measurement of the left eye, Macula, Inner Plexiform Layer, Nasal Outer Parafovea}
    \item{L_MAC_IPL_I1}{Measurement of the left eye, Macula, Inner Plexiform Layer, Inferior Inner Parafovea}
    \item{L_MAC_IPL_I2}{Measurement of the left eye, Macula, Inner Plexiform Layer, Inferior Outer Parafovea}
    \item{L_MAC_IPL_T1}{Measurement of the left eye, Macula, Inner Plexiform Layer, Temporal Inner Parafovea}
    \item{L_MAC_IPL_T2}{Measurement of the left eye, Macula, Inner Plexiform Layer, Temporal Outer Parafovea}
    \item{L_MAC_IPL_C}{Measurement of the left eye, Macula, Inner Plexiform Layer, Center Fovea}
    \item{L_MAC_INL_S1}{Measurement of the left eye, Macula, Inner Nuclear Layer, Superior Inner Parafovea}
    \item{L_MAC_INL_S2}{Measurement of the left eye, Macula, Inner Nuclear Layer, Superior Outer Parafovea}
    \item{L_MAC_INL_N1}{Measurement of the left eye, Macula, Inner Nuclear Layer, Nasal Inner Parafovea}
    \item{L_MAC_INL_N2}{Measurement of the left eye, Macula, Inner Nuclear Layer, Nasal Outer Parafovea}
    \item{L_MAC_INL_I1}{Measurement of the left eye, Macula, Inner Nuclear Layer, Inferior Inner Parafovea}
    \item{L_MAC_INL_I2}{Measurement of the left eye, Macula, Inner Nuclear Layer, Inferior Outer Parafovea}
    \item{L_MAC_INL_T1}{Measurement of the left eye, Macula, Inner Nuclear Layer, Temporal Inner Parafovea}
    \item{L_MAC_INL_T2}{Measurement of the left eye, Macula, Inner Nuclear Layer, Temporal Outer Parafovea}
    \item{L_MAC_INL_C}{Measurement of the left eye, Macula, Inner Nuclear Layer, Center Fovea}
    \item{L_MAC_OPL_S1}{Measurement of the left eye, Macula, Outer Plexiform Layer, Superior Inner Parafovea}
    \item{L_MAC_OPL_S2}{Measurement of the left eye, Macula, Outer Plexiform Layer, Superior Outer Parafovea}
    \item{L_MAC_OPL_N1}{Measurement of the left eye, Macula, Outer Plexiform Layer, Nasal Inner Parafovea}
    \item{L_MAC_OPL_N2}{Measurement of the left eye, Macula, Outer Plexiform Layer, Nasal Outer Parafovea}
    \item{L_MAC_OPL_I1}{Measurement of the left eye, Macula, Outer Plexiform Layer, Inferior Inner Parafovea}
    \item{L_MAC_OPL_I2}{Measurement of the left eye, Macula, Outer Plexiform Layer, Inferior Outer Parafovea}
    \item{L_MAC_OPL_T1}{Measurement of the left eye, Macula, Outer Plexiform Layer, Temporal Inner Parafovea}
    \item{L_MAC_OPL_T2}{Measurement of the left eye, Macula, Outer Plexiform Layer, Temporal Outer Parafovea}
    \item{L_MAC_OPL_C}{Measurement of the left eye, Macula, Outer Plexiform Layer, Center Fovea}
    \item{L_MAC_ONL_S1}{Measurement of the left eye, Macula, Outer Nuclear Layer, Superior Inner Parafovea}
    \item{L_MAC_ONL_S2}{Measurement of the left eye, Macula, Outer Nuclear Layer, Superior Outer Parafovea}
    \item{L_MAC_ONL_N1}{Measurement of the left eye, Macula, Outer Nuclear Layer, Nasal Inner Parafovea}
    \item{L_MAC_ONL_N2}{Measurement of the left eye, Macula, Outer Nuclear Layer, Nasal Outer Parafovea}
    \item{L_MAC_ONL_I1}{Measurement of the left eye, Macula, Outer Nuclear Layer, Inferior Inner Parafovea}
    \item{L_MAC_ONL_I2}{Measurement of the left eye, Macula, Outer Nuclear Layer, Inferior Outer Parafovea}
    \item{L_MAC_ONL_T1}{Measurement of the left eye, Macula, Outer Nuclear Layer, Temporal Inner Parafovea}
    \item{L_MAC_ONL_T2}{Measurement of the left eye, Macula, Outer Nuclear Layer, Temporal Outer Parafovea}
    \item{L_MAC_ONL_C}{Measurement of the left eye, Macula, Outer Nuclear Layer, Center Fovea}
    \item{L_MAC_RPE_S1}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Superior Inner Parafovea}
    \item{L_MAC_RPE_S2}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Superior Outer Parafovea}
    \item{L_MAC_RPE_N1}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Nasal Inner Parafovea}
    \item{L_MAC_RPE_N2}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Nasal Outer Parafovea}
    \item{L_MAC_RPE_I1}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Inferior Inner Parafovea}
    \item{L_MAC_RPE_I2}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Inferior Outer Parafovea}
    \item{L_MAC_RPE_T1}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Temporal Inner Parafovea}
    \item{L_MAC_RPE_T2}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Temporal Outer Parafovea}
    \item{L_MAC_RPE_C}{Measurement of the left eye, Macula, Retinal Pigment Epithelium, Center Fovea}
    \item{L_MAC_PHOTO_S1}{Measurement of the left eye, Macula, Unknown Layer, Superior Inner Parafovea}
    \item{L_MAC_PHOTO_S2}{Measurement of the left eye, Macula, Unknown Layer, Superior Outer Parafovea}
    \item{L_MAC_PHOTO_N1}{Measurement of the left eye, Macula, Unknown Layer, Nasal Inner Parafovea}
    \item{L_MAC_PHOTO_N2}{Measurement of the left eye, Macula, Unknown Layer, Nasal Outer Parafovea}
    \item{L_MAC_PHOTO_I1}{Measurement of the left eye, Macula, Unknown Layer, Inferior Inner Parafovea}
    \item{L_MAC_PHOTO_I2}{Measurement of the left eye, Macula, Unknown Layer, Inferior Outer Parafovea}
    \item{L_MAC_PHOTO_T1}{Measurement of the left eye, Macula, Unknown Layer, Temporal Inner Parafovea}
    \item{L_MAC_PHOTO_T2}{Measurement of the left eye, Macula, Unknown Layer, Temporal Outer Parafovea}
    \item{L_MAC_PHOTO_C}{Measurement of the left eye, Macula, Unknown Layer, Center Fovea}
    }

Layer abbreviations include RNFL (Retinal Nerve Fiber Layer), GCL (Ganglion Cell Layer), IPL (Inner Plexiform Layer), INL (Inner Nuclear Layer), OPL (Outer Plexiform Layer), ONL (Outer Nuclear Layer), RPE (Retinal Pigment Epithelium), and IRL (Inner Retinal Layer).
}
\source{
Steingrube, N. (2023). Analysis of early changes in the retina and their association with diabetic alterations of the corneal nerve fiber plexus in type 2 diabetes mellitus. Unpublished doctoral dissertation. Faculty of Medicine, Heinrich-Heine University Dusseldorf.

Department of Ophthalmology, University Hospital Dusseldorf, Heinrich Heine University, Germany
}
\description{
A dataset containing detailed measurements from a study investigating the relationship between diabetes and eye health. The dataset includes patient demographics, visual acuity, and extensive macular metrics derived from optical coherence tomography (OCT) imaging.
}
\keyword{datasets}
