% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-clrange.R
\name{setCLranges}
\alias{setCLranges}
\title{Get Chroma and Luminance ranges for the given lightMode}
\usage{
setCLranges(
  lightMode = NULL,
  Crange = getOption("jam.Crange"),
  Lrange = getOption("jam.Lrange"),
  Cgrey = getOption("jam.Cgrey", 5),
  adjustRgb = getOption("jam.adjustRgb", 0),
  setOptions = c("FALSE", "ifnull", "TRUE"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{lightMode}{boolean indicating whether the background color
is light (TRUE is bright), or dark (FALSE is dark.) By default
it calls \code{checkLightMode()} which queries \code{getOption("lightMode")}.}

\item{Crange}{numeric range of chroma values, ranging
between 0 and 100. By default, \code{getOptions("Crange")} is used,
otherwise defaults will be assigned based upon \code{lightMode}.}

\item{Lrange}{numeric range of luminance values, ranging
between 0 and 100. By default, \code{getOptions("Crange")} is used,
otherwise defaults will be assigned based upon \code{lightMode}.}

\item{Cgrey}{numeric chroma (C) value, which defines grey colors at or
below this chroma. Any colors at or below the grey cutoff will have
their C values unchanged. This mechanism prevents converting black
to red, for example. To disable the effect, set \code{Cgrey=-1}.}

\item{adjustRgb}{numeric color adjustment factor, used during the
conversion of RGB colors to the ANSI-compatible colors used
by the \code{crayon} pacakge. The ANSI color range does not include
a full RGB palette, and the conversion is somewhat lossy.
By default, \code{getOptions("jam.adjustRgb")} is used to store a
globally re-usable value.}

\item{setOptions}{character or logical whether to update \code{options()}
\code{"jam.Crange"} and \code{"jam.Lrange"}, with the following behavior:
\itemize{
\item \code{"ifnull"} will update only \code{options()} which were previously \code{NULL}
\item \code{FALSE} or \code{"FALSE"} does not update \code{options()}
\item \code{TRUE} or \code{"TRUE"} will update \code{options()} with values determined
by this function.
}}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{list} with elements:
\describe{
\item{Crange}{Numeric vector of length 2, defining the
HCL chroma (C) range.}
\item{Lrange}{Numeric vector of length 2, defining the
HCL luminance (L) range.}
\item{adjustRgb}{Numeric vector of length 1, defining the
adjustment to apply during RGB-to-ANSI color conversion.}
\item{Cgrey}{Numeric vector of length 1, defining the
HCL chroma (C) value below which colors are considered greyscale,
and are converted to ANSI greyscale colors.
HCL chroma ranges from 0 to 100. Set value \code{Cgrey=-1} or
\code{Cgrey=FALSE} to disable this logic, causing colors to be
matched using all available ANSI color values.}
}
}
\description{
Return Crange, Lrange, Cgrey, adjustRgb values for the given lightMode,
intended to provide ranges suitable for contrasting text displayed
on a light or dark background.
}
\details{
This function is intended mainly for internal use by \code{jamba}
such as \code{printDebug()}, and \code{make_styles()}, which is also mainly
intended for console text or other printed text output.
The utility of this function is to store the logic of determining
sensible default ranges.

Companion functions:
\itemize{
\item \code{applyCLranges()} is used to apply the ranges to a vector of R colors.
\item \code{checkLightMode()} is used to detect whether console output is expected
to have a light or dark background.
}
}
\examples{
setCLranges(lightMode=FALSE)

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
