% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_jags_rep.R
\name{tar_jags_rep_run}
\alias{tar_jags_rep_run}
\title{Run a batch of iterations for a jags model
and return only strategic output.}
\usage{
tar_jags_rep_run(
  jags_lines,
  jags_name,
  jags_file,
  parameters.to.save,
  data,
  variables = NULL,
  summaries = NULL,
  summary_args = NULL,
  transform = NULL,
  reps,
  output,
  n.cluster = n.cluster,
  n.chains = n.chains,
  n.iter = n.iter,
  n.burnin = n.burnin,
  n.thin = n.thin,
  jags.module = jags.module,
  inits = inits,
  RNGname = RNGname,
  stdout = stdout,
  stderr = stderr,
  progress.bar = progress.bar,
  refresh = refresh
)
}
\arguments{
\item{jags_lines}{Character vector of lines from a JAGS file.}

\item{jags_name}{Friendly suffix of the jags model target.}

\item{jags_file}{Original path to the input jags file.}

\item{parameters.to.save}{Model parameters to save, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{data}{A list, the original JAGS dataset.}

\item{variables}{Character vector of model parameter names.
The output posterior summaries are restricted to these variables.}

\item{summaries}{List of summary functions passed to \code{...} in
\code{posterior::summarize_draws()} through \verb{$summary()}
on the \code{CmdStanFit} object.}

\item{summary_args}{List of summary function arguments passed to
\code{.args} in \code{posterior::summarize_draws()} through \verb{$summary()}
on the \code{CmdStanFit} object.}

\item{transform}{Symbol or \code{NULL}, name of a function that accepts
arguments \code{data} and \code{draws} and returns a data frame. Here,
\code{data} is the JAGS data list supplied to the model, and \code{draws}
is a data frame with one column per model parameter and one row
per posterior sample. Any arguments other than \code{data} and \code{draws}
must have valid default values because \code{jagstargets} will not
populate them. See the simulation-based calibration discussion
thread at \url{https://github.com/ropensci/jagstargets/discussions/31}
for an example.}

\item{output}{Character of length 1 denoting the type of output \code{tibble}
to return: \code{"draws"} for MCMC samples (which could take up a lot of space)
\code{"summary"} for lightweight posterior summary statistics,
and \code{"dic"} for the overall deviance information criterion
and effective number of parameters}

\item{n.cluster}{Number of parallel processes, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.chains}{Number of MCMC chains, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.iter}{Number if iterations (including warmup), passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.burnin}{Number of warmup iterations, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.thin}{Thinning interval, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{jags.module}{Character vector of JAGS modules to load, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{inits}{Initial values of model parameters, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{RNGname}{Choice of random number generator, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{stdout}{Character of length 1, file path to write the stdout stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stdout.
Does not apply to messages, warnings, or errors.}

\item{stderr}{Character of length 1, file path to write the stderr stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stderr.
Does not apply to messages, warnings, or errors.}

\item{progress.bar}{Type of progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{refresh}{Frequency for refreshing the progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}
}
\value{
A data frame of posterior summaries.
}
\description{
Not a user-side function. Do not invoke directly.
}
\keyword{internal}
