% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw_alstructure.R
\name{jackstraw_alstructure}
\alias{jackstraw_alstructure}
\title{Non-Parametric Jackstraw for ALStructure}
\usage{
jackstraw_alstructure(
  dat,
  r,
  FUN,
  r1 = NULL,
  s = NULL,
  B = NULL,
  covariate = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dat}{a genotype matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{r}{a number of significant LFs.}

\item{FUN}{a function to ALStructure}

\item{r1}{a numeric vector of LFs of interest (implying you are not interested in all \code{r} LFs).}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations. There will be a total of \code{s*B} null statistics.}

\item{covariate}{a data matrix of covariates with corresponding \code{n} observations (do not include an intercept term).}

\item{verbose}{a logical specifying to print the computational progress.}
}
\value{
\code{jackstraw_alstructure} returns a list consisting of
\item{p.value}{\code{m} p-values of association tests between variables and their LFs}
\item{obs.stat}{\code{m} observed deviances}
\item{null.stat}{\code{s*B} null deviances}
}
\description{
Test association between the observed variables and population structure estimated by ALStructure.
}
\details{
This function uses ALStructure from Cabreros and Storey (2019). A deviation \code{dev} in logistic regression
(the full model with \code{r} LFs vs. the intercept-only model) is used to assess association.
}
\examples{
\dontrun{
# load genotype data to analyze (not shown) into this variable
X
# choose the number of ancestries
r <- 3

# load alstructure package (install from https://github.com/StoreyLab/alstructure)
library(alstructure)
# define the function this way, a function of the genotype matrix only
FUN <- function(x) t( alstructure(x, d_hat = r)$Q_hat )

# calculate p-values (and other statistics) for each SNP
out <- jackstraw_alstructure( X, r, FUN )
}

}
\references{
Chung and Storey (2015) Statistical significance of variables driving systematic variation in high-dimensional data. Bioinformatics, 31(4): 545-554 \doi{10.1093/bioinformatics/btu674}
}
\seealso{
\link{jackstraw_pca} \link{jackstraw}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
