% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw_parametric.R
\name{jackstraw.parametric}
\alias{jackstraw.parametric}
\title{Parametric Jackstraw}
\usage{
jackstraw.parametric(dat, FUN = function(x) fast.svd(x)$v[, 1:r, drop =
  FALSE], noise = function(x) rnorm(x, mean = 0, sd = 1), r = NULL,
  r1 = NULL, s = NULL, B = NULL, covariate = NULL, verbose = TRUE,
  seed = NULL)
}
\arguments{
\item{dat}{a data matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{FUN}{provide a function to estimate LVs. Must output \code{r} estimated LVs in a \code{n*r} matrix.}

\item{noise}{specify a parametric distribution to generate a noise term.}

\item{r}{a number of significant latent variables.}

\item{r1}{a numeric vector of latent variables of interest.}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations.}

\item{covariate}{a model matrix of covariates with \code{n} observations. Must include an intercept in the first column.}

\item{verbose}{a logical indicator as to whether to print the progress.}

\item{seed}{a seed for the random number generator.}
}
\value{
\code{jackstraw.parametric} returns a list consisting of
\item{p.value}{the \code{m} p-values of association tests between variables and their principal components}
\item{obs.stat}{the observed F-test statistics}
\item{null.stat}{the \code{s*B} null F-test statistics}
}
\description{
Estimates statistical significance of association between variables and their latent variables, from a parametric jackstraw procedure.
}
\details{
This function estimates statistical significance of association between variables and latent variables
using a parametric distribution of a noise term. A small number \code{s} of observed variables are replaced by
synthetic null variables generated from a specified distribution (such as Normal(0,1)).
After applying a latent variable estimation function on this newly generated matrix (with \code{s} synthetic nulls
and \code{m-s} intact observed variables), F-test statistics between estimated latent variables and \code{s} synthetic nulls
are called the jackstraw statistics. P-values are computed by comparing observed F-test statistics against \code{s*B} jackstraw statistics.

Note that unless you have a strong reason to use a parametric distribution, it is advised to use the non-parametric jackstraw.
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
\seealso{
\link{jackstraw.FUN}

\link{jackstraw}
}

