% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sonarFind}
\alias{sonarFind}
\title{Run a saved find query}
\usage{
sonarFind(connection, queryName, queryCol, bind = list(), limit = NULL,
  idCol = "_id", publishedBy = NULL, colClasses = NA)
}
\arguments{
\item{connection}{a SonarConnection object created with
\code{\link{new.SonarConnection}}}

\item{queryName}{the name of the saved query to execute}

\item{queryCol}{a collection in the database to use with the query}

\item{bind}{a list of bind variables and their values}

\item{limit}{the maximum number of results to return}

\item{idCol}{the name of a field which uniquely identifies each document.
This will be used for the row names in the returned data frame. The
default is X_id, which is the name of Mongo's _id field (adjusted by
\code{\link{make.names}}).}

\item{publishedBy}{the name of the user who we expect published the API}

\item{colClasses}{a list of column names and their respective classes, as
  used in \code{\link{read.csv}}. This may be necessary if some columns'
  types are not being detected automatically.}
}
\description{
Execute a find query which has been saved and published in JSON Studio
Finder, and get the result in a data frame.
}
\details{
The parameters for this function are explained in greater detail in the
JSON Studio help page \emph{Using the Gateway}.
}
\examples{
connection <- new.SonarConnection('https://example.com', 'localhost', 'test')

delays <- sonarFind(connection, 'delayed_flights', 'WAFlights')
cor(delays$ACTUAL_ELAPSED_TIME, delays$WEATHER_DELAY)

tx_to_co <- sonarFind(connection, 'flights_to', 'TXFlights',
  bind=list(state="CO"),
  colClasses=c(DAY_OF_MONTH='factor', DEST_AIRPORT_ID='factor'))
hist(tx_to_co$ACTUAL_ELAPSED_TIME)
}
\seealso{
\url{http://jsonstudio.com/wp-content/uploads/2014/04/manual141/_build/html/index.html}

Other connection: \code{\link{new.SonarConnection}};
  \code{\link{sonarAgg}}; \code{\link{sonarCSV}};
  \code{\link{sonarJSON}}

Other csv: \code{\link{sonarAgg}}; \code{\link{sonarCSV}}
}
\keyword{database}

