% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table_functions.R
\name{ivdoctr}
\alias{ivdoctr}
\title{Generates parameter estimates given user restrictions and data}
\usage{
ivdoctr(
  y_name,
  T_name,
  z_name,
  data,
  example_name,
  controls = NULL,
  robust = FALSE,
  r_TstarU_restriction = c(-1, 1),
  k_restriction = c(1e-04, 1),
  n_draws = 5000,
  n_RF_draws = 1000,
  n_IS_draws = 1000,
  resample = FALSE
)
}
\arguments{
\item{y_name}{Character string with the column name of the dependent variable}

\item{T_name}{Character string with the column name of the endogenous regressor(s)}

\item{z_name}{Character string with the column name of the instrument(s)}

\item{data}{Data frame}

\item{example_name}{Character string naming estimation}

\item{controls}{Vector of character strings specifying the exogenous variables}

\item{robust}{Indicator for heteroskedasticity-robust standard errors}

\item{r_TstarU_restriction}{2-element vector of min and max of r_TstarU.}

\item{k_restriction}{2-element vector of min and max of kappa.}

\item{n_draws}{Number of draws when generating frequentist-friendly draws of the covariance matrix}

\item{n_RF_draws}{Number of reduced-form draws}

\item{n_IS_draws}{Number of draws on the identified set}

\item{resample}{Indicator of whether or not to resample using magnification factor}
}
\value{
List with elements:
\itemize{
 \item ols: lm object of OLS estimation,
 \item iv: ivreg object of the IV estimation
 \item n: Number of observations
 \item b_OLS: OLS point estimate
 \item se_OLS: OLS standard errors
 \item b_IV: IV point estimate
 \item se_IV: IV standard errors
 \item k_lower: lower bound of kappa
 \item p_empty: fraction of parameter draws that yield an empty identified set
 \item p_valid: fraction of parameter draws compatible with a valid instrument
 \item r_uz_full_interval: 90\% posterior credible interval for fully identified set of rho
 \item beta_full_interval: 90\% posterior credible interval for fully identified set of beta
 \item r_uz_median: posterior median for partially identified rho
 \item r_uz_partial_interval: 90\% posterior credible interval for partially identified set of rho under a conditionally uniform reference prior
 \item beta_median: posterior median for partially identified beta
 \item beta_partial_interval: 90\% posterior credible interval for partially identified set of beta under a conditionally uniform reference prior
 \item a0: If treatment is binary, mis-classification probability of no-treatment case. NULL otherwise
 \item a1: If treatment is binary, mis-classification probability of treatment case. NULL otherwise
 \item psi_lower: lower bound for psi
 \item binary: logical indicating if treatment is binary
 \item k_restriction: User-specified bounds on kappa
 \item r_TstarU_restriction: User-specified bounds on r_TstarU
 }
}
\description{
Generates parameter estimates given user restrictions and data
}
\examples{
library(ivdoctr)
endog <- c(0, 0.9)
meas <- c(0.6, 1)

colonial_example1 <- ivdoctr(y_name = "logpgp95", T_name = "avexpr",
                            z_name = "logem4", data = colonial,
                            controls = NULL, robust = FALSE,
                            r_TstarU_restriction = endog,
                            k_restriction = meas,
                            example_name = "Colonial Origins")

}
