% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_response.R
\name{spatial_response}
\alias{spatial_response}
\title{Calculate spatial response or dependence plot.}
\usage{
spatial_response(
  model,
  var_occ,
  variables,
  shap_nsim = 0,
  seed = 10L,
  visualize = FALSE
)
}
\arguments{
\item{model}{(\code{isolation_forest}). It could
be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.}

\item{var_occ}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations.}

\item{variables}{(\code{stars}) The \code{stars} of environmental variables.
It should have multiple \code{attributes} instead of \code{dims}.
If you have \code{raster} object instead, you
could use \code{\link{st_as_stars}} to convert it to \code{stars} or use
\code{\link{read_stars}} directly read source data as a \code{stars}.
You also could use item \code{variables} of \code{POIsotree} made by function
\code{\link{isotree_po}}.}

\item{shap_nsim}{(\code{integer}) The number of Monte Carlo repetitions in SHAP
method to use for estimating each Shapley value. See details in documentation
of function \code{\link{explain}} in package \code{fastshap}. Set it to 0 if you
don't want to make SHAP-based spatial dependence. When the number of variables
is large, a smaller shap_nsim could be used. Be cautious that making
SHAP-based spatial dependence will be slow because of Monte-Carlo
computation for all pixels. But it is worth the time because it is much more
informative. See details in documentation of function \code{\link{explain}}
in package \code{fastshap}. The default is 0. Usually a value 10 - 20 is enough.}

\item{seed}{(\code{integer}) The seed for any random progress. The default is \code{10L}.}

\item{visualize}{(\code{logical}) if \code{TRUE}, plot the response curves.
The default is \code{FALSE}.}
}
\value{
(\code{SpatialResponse}) A list of
\itemize{
\item{spatial_marginal_response (\code{list}) A list of \code{stars} object of spatially
marginal response of all variables}
\item{spatial_independent_response (\code{list}) A list of \code{stars} object of spatially
independent response of all variables}
\item{spatial_shap_dependence (\code{list}) A list of \code{stars} object of spatially
SHAP-based response of all variables}
}
}
\description{
Calculate spatially marginal, independence, and SHAP-based
response plots.
}
\details{
The values show how each environmental variable affects the modeling
prediction in space. These maps could help to answer questions of where in
terms of environmental response. Compared to marginal dependence or
independent dependence maps, SHAP-based maps are way more informative because
SHAP-based dependence explain the contribution of each variable to final result.
}
\examples{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))

mod <- isotree_po(
  occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 20,
  sample_rate = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

spatial_responses <- spatial_response(
  model = mod$model,
  var_occ = mod$var_train \%>\% st_drop_geometry(),
  variables = mod$variables,
  shap_nsim = 1)
plot(spatial_responses)

}
\seealso{
\code{\link{plot.SpatialResponse}}
}
