% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itsadug.R
\docType{package}
\name{itsadug}
\alias{itsadug}
\alias{itsadug-package}
\title{Interpreting Time Series, Autocorrelated Data Using GAMMs (itsadug)}
\description{
Itsadug provides a set of functions that facilitate the evaluation, 
interpretation, and visualization of GAMM models that are implemented in 
the package \code{\link[mgcv]{mgcv}}.
}
\section{Tutorials}{

\itemize{
\item \code{vignette("inspect", package="itsadug")} - summarizes different 
functions for visualizing the model.
\item \code{vignette("test", package="itsadug")} - summarizes 
different functions for significance testing.
\item \code{vignette("acf", package="itsadug")} - summarizes how to check 
and account for autocorrelation in the residuals.
}
Also available online: \url{www.jacolienvanrij.com/itsadug}.
}

\section{Interpretation and visualization}{

Main functions that are provided in \code{itsadug} for interpretation and 
visualization of GAMM models:
\itemize{
  \item \code{\link{pvisgam}} plots partial interaction surfaces; it also 
allows for visualizing 3-way or higher interactions.
  \item \code{\link{fvisgam}} plots summed interaction surfaces, with the 
possibility to exclude random effects.
  \item \code{\link{plot_smooth}} plots 1D model estimates, and has the 
possibility to exclude random effects. 
  \item \code{\link{plot_parametric}} plot group estimates.
  \item \code{\link{inspect_random}} plots and optionally averages random 
smooths
  \item \code{\link{plot_data}} plots the data
  \item \code{\link{plot_topo}} plots EEG topographies
}
}

\section{Testing for significance}{

\itemize{
\item \code{\link{compareML}} Performs Chisquare test on two models
\item \code{\link{plot_diff}} Calculates and visualizes the difference 
between two conditions within a model
\item \code{\link{plot_diff2}} Calculates and visualizes the 2 dimensional 
difference between two conditions within a model
}
}

\section{Evaluation of the model}{

\itemize{
\item \code{\link{check_resid}} plots four different plots to inspect the 
distribution of and structure in the residuals
\item \code{\link{plot_modelfit}} plots an overlay of the data and the 
modelfit for randomly selected trials
\item \code{\link{diagnostics}} produces plots of the distributions of 
residuals and predictors in the model
}
}

\section{Checking and handling autocorrelation}{

\itemize{
\item \code{\link{acf_resid}} different ways to inspect autocorrelation in 
the residuals
\item \code{\link{start_event}} creates an AR.start column 
\item \code{\link{resid_gam}} returns residuals corrected for the AR1 model
}
}

\section{Predictions}{

Further, there are some wrappers around the \code{\link[mgcv]{predict.gam}}
function to facilitate the extraction of model predictions. These can be 
used for customized plots. See for an example in the vignette 
"plotfunctions" 
(\code{vignette("plotfunctions", package="itsadug")}).
\itemize{
  \item \code{\link{get_predictions}} for getting the estimates for given 
settings of some or all of the model predictors;
  \item \code{\link{get_difference}} for extracting the difference between 
two conditions or two smooths or two surfaces.
  \item \code{\link{get_modelterm}} for extracting the smooth term (
partial) estimates.
  \item \code{\link{inspect_random}} and \code{\link{get_random}} for 
extracting random effects only.
}
}

\section{Notes}{

\itemize{
\item Use \code{\link{infoMessages}(FALSE)} to suppress all 
information messages for the current session. 
This may be helpful when creating knitr or
R markdown reports.
\item The vignettes are available via \code{browseVignettes()}. 
When working on a server via the command line, 
using \code{ssh -X} instead of \code{ssh} may make the 
HTML files available.
\item A list of all available functions is provided in 
\code{help(package="itsadug")}.
}
}
\author{
Jacolien van Rij, Martijn Wieling, R.Harald Baayen, Hedderik van Rijn

Maintainer: Jacolien van Rij (\email{vanrij.jacolien@gmail.com})

University of Groningen, The Netherlands & University of Tuebingen, Germany
}

