% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{diff_terms}
\alias{diff_terms}
\title{Compare the formulas of two models and return the difference(s).}
\usage{
diff_terms(model1, model2)
}
\arguments{
\item{model1}{A fitted regression model (using lm, glm, gam, or bam).}

\item{model2}{A fitted regression model (using lm, glm, gam, or bam).}
}
\value{
A list with model terms that are not shared by both models.
}
\description{
Compare the formulas of two models and return the difference(s).
}
\examples{
data(simdat)

# Fit simple GAM model:
gam1 <- bam(Y ~ s(Time), data=simdat)
gam2 <- bam(Y ~ Group+s(Time), data=simdat)
diff_terms(gam1, gam2)

}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{findAbsMin}}, \code{\link{find_difference}},
  \code{\link{find_n_neighbors}}, \code{\link{getDec}},
  \code{\link{getRange}}, \code{\link{group_sort}},
  \code{\link{list2str}}, \code{\link{missing_est}},
  \code{\link{move_n_point}}, \code{\link{print_summary}},
  \code{\link{se}}, \code{\link{summary_data}},
  \code{\link{timeBins}}
}

