% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fvisgam.R
\name{fvisgam}
\alias{fvisgam}
\alias{vis.gam2}
\title{Visualization of nonlinear interactions.}
\usage{
fvisgam(x, view = NULL, cond = list(), n.grid = 30, too.far = 0,
  col = NA, color = "topo", contour.col = NULL, add.color.legend = TRUE,
  se = -1, plot.type = "contour", zlim = NULL, nCol = 50,
  rm.ranef = NULL, print.summary = TRUE, ...)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{view}{A two-value vector containing the names of the two main effect
terms to be displayed on the x and y dimensions of the plot. Note that
variables coerced to factors in the model formula won't work as view
variables.}

\item{cond}{A named list of the values to use for the other predictor terms
(not in view). Used for choosing between smooths that share the same view
predictors.}

\item{n.grid}{The number of grid nodes in each direction used for
calculating the plotted surface.}

\item{too.far}{Plot grid nodes that are too far from the points defined by
the variables given in view can be excluded from the plot. too.far
determines what is too far. The grid is scaled into the unit square along
with the view variables and then grid nodes more than too.far from the
predictor variables are excluded.}

\item{col}{The colors for the facets of the plot.}

\item{color}{The color scheme to use for plots. One of "topo", "heat",
"cm", "terrain", "gray" or "bw".}

\item{contour.col}{sets the color of contours when using plot.}

\item{add.color.legend}{Logical: whether or not to add a color legend.
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{se}{If less than or equal to zero then only the predicted surface is
plotted, but if greater than zero, then 3 surfaces are plotted, one at the
predicted values minus se standard errors, one at the predicted values and
one at the predicted values plus se standard errors.}

\item{plot.type}{one of "contour" or "persp" (default is "contour").}

\item{zlim}{A two item array giving the lower and upper limits for the z-
axis scale. NULL to choose automatically.}

\item{nCol}{The number of colors to use in color schemes.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is TRUE.}

\item{print.summary}{Logical: whether or not to print a summary.}

\item{...}{other options to pass on to persp, image or contour. In
particular ticktype="detailed" will add proper axes labeling to the plots.}
}
\description{
Produces perspective or contour plot views of gam model
predictions of the additive effects interactions.
The code is based on the script for \code{\link[mgcv]{vis.gam}},
but allows to cancel random effects.
}
\examples{
data(simdat)

\dontrun{
# Model with random effect and interactions:
m1 <- bam(Y ~ te(Time, Trial)+s(Time, Subject, bs='fs', m=1),
    data=simdat)

# Plot summed effects:
vis.gam(m1, view=c("Time", "Trial"), plot.type='contour', color='topo')
# Same plot:
fvisgam(m1, view=c("Time", "Trial"), rm.ranef=FALSE)
# Without random effects included:
fvisgam(m1, view=c("Time", "Trial"), rm.ranef=TRUE)
}
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Jacolien van Rij and Martijn Wieling.
Modification of \code{\link[mgcv]{vis.gam}} from
package \code{\link[mgcv]{mgcv}} of Simon N. Wood.
}
\seealso{
\code{\link[mgcv]{vis.gam}}, \code{\link[mgcv]{plot.gam}}

Other functions for interpreting nonlinear effects: \code{\link{plotDiff2D}},
  \code{\link{plot_diff2}}; \code{\link{plotDiff}},
  \code{\link{plot_diff}}; \code{\link{plot_parametric}};
  \code{\link{plot_smooth}}; \code{\link{pvis.gam}},
  \code{\link{pvisgam}}
}

