% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{agi}
\alias{agi}
\title{Análisis gráfico de ítems.}
\usage{
agi(respuestas, clave, alternativas, nGrupos = 4, digitos = 2)
}
\arguments{
\item{respuestas}{Un data frame con las alternativas seleccionadas por los estudiantes
en cada ítem de la prueba.}

\item{clave}{Un data frame con las alternativas correctas para cada ítem.}

\item{alternativas}{Un vector con las alternativas posibles para cada ítem.}

\item{nGrupos}{Número de grupos en los que se categorizarán los estudiantes
según el puntaje obtenido en la prueba.}

\item{digitos}{La cantidad de dígitos significativos que tendrá el resultado.}
}
\value{
Una lista con dos listas en su interior. La primera sublista contiene
a su vez otra lista con los los datos utilizados en los gráficos para cada ítem.
La segunda sublista contiene una lista con los gráficos de cada ítem.
}
\description{
El análisis gráfico de ítems (agi) permite visualizar las alternativas que eligen
los estudiantes según su desempeño general en la prueba. El agi proporciona
información esencial y fácilmente interpretable acerca de características técnicas
del ítem tales como su dificultad y poder de discriminación.
}
\details{
Los estudiantes se clasifican habitualmente en 4 categorías según su puntaje
alcanzado en la prueba. La proporción de estudiantes de cada grupo que seleccionó
una alternativa determinada se muestra en el eje Y. Por ejemplo, en la siguiente
figura se puede observar que todos los estudiantes del grupo 4 (mejor desempeño)
seleccionaron la alternativa correcta D, mientras que el 25\% de los estudiantes
del grupo 1 (peor desempeño) seleccionaron esta opción.

\if{html}{\figure{i50.jpeg}{options: width=500 alt="Figura: Análisis gráfico ítem 01."}}
}
\examples{
respuestas <- datos[,-1]
alternativas <- LETTERS[1:5]

dataplots <- agi(respuestas, clave, alternativas)

dataplots$datos$i01
dataplots$datos$i25
dataplots$datos$i50

dataplots$plots$i01
dataplots$plots$i25
dataplots$plots$i50

}
\references{
Guadalupe de los Santos (2010). Manual para el análisis gráfico de ítems.
Universidad Autónoma de Baja California. Recuperado de
\href{http://www.educacionbc.edu.mx/departamentos/evaluacion/eacademicos/archivos/jornadasBC/MANUAL_PAGI.pdf}{manual_pagi.pdf}
}
