% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_topo}
\alias{set_topo}
\title{Set the topology in a network model.}
\usage{
set_topo(nm, ..., from = NULL, to = NULL)
}
\arguments{
\item{nm}{A \code{networkModel} object (output from
\code{\link{new_networkModel}}).}

\item{...}{One or more strings describing the links defining the network
topology. Optionally, links can be given as a data frame. See the
examples for more details about acceptable input formats.}

\item{from}{Optional, string containing the column name for sources if
links are provided as a data frame.}

\item{to}{Optional, string containing the column name for destinations if
links are provided as a data frame.}
}
\value{
A \code{networkModel} object.
}
\description{
Set the topology in a network model.
}
\examples{
library(magrittr)

# A single string can describe several links in one go.
m <- new_networkModel() \%>\%
  set_topo("NH4, NO3 -> epi -> pseph, tricor")
m
topo(m)

# Several strings can be given as distinct arguments.
m2 <- new_networkModel() \%>\%
  set_topo("NH4, NO3 -> epi -> pseph, tricor",
           "NH4 -> FBOM, CBOM", "CBOM <- NO3")
m2
topo(m2)

# Multiple strings can be also be combined into a single argument with `c()`.
links <- c("NH4, NO3 -> epi -> pseph, tricor", "NH4 -> FBOM, CBOM",
           "CBOM <- NO3")
m3 <- new_networkModel() \%>\%
  set_topo(links)
m3
topo(m3)

# A data frame can be used to specify the links.
links <- data.frame(source = c("NH4", "NO3", "epi"),
                    consumer = c("epi", "epi", "petro"))
links
m4 <- new_networkModel() \%>\%
  set_topo(links, from = "source", to = "consumer")
m4
m4$topology[[1]]

}
