% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_density.R
\docType{methods}
\name{ternary_density}
\alias{ternary_density}
\alias{ternary_density-method}
\alias{ternary_density,numeric,numeric,numeric-method}
\alias{ternary_density,ANY,missing,missing-method}
\title{Density Contour Lines}
\usage{
ternary_density(x, y, z, ...)

\S4method{ternary_density}{numeric,numeric,numeric}(
  x,
  y,
  z,
  h = NULL,
  n = 25,
  nlevels = 10,
  levels = NULL,
  palette = function(i) grDevices::hcl.colors(i, "YlOrRd", rev = TRUE),
  ...
)

\S4method{ternary_density}{ANY,missing,missing}(
  x,
  h = NULL,
  n = 25,
  nlevels = 10,
  levels = NULL,
  palette = function(i) grDevices::hcl.colors(i, "YlOrRd", rev = TRUE),
  ...
)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[=ternary_lines]{ternary_lines()}}.}

\item{h}{A length-one \code{\link{numeric}} vector giving the bandwidth.}

\item{n}{A length-one \code{\link{numeric}} specifying the number of grid points.}

\item{nlevels}{A length-one \code{\link{numeric}} vector specifying the number of
contour levels desired. Only used if \code{levels} is \code{NULL}.}

\item{levels}{A \code{\link{numeric}} vector of levels at which to draw contour lines.}

\item{palette}{A color palette \code{\link{function}} that takes a single integer
argument (the number of levels) and returns a vector of colors.}
}
\value{
\code{ternary_density()} is called it for its side-effects.

Invisibly returns a \code{\link{list}} with elements \code{levels} (the contour levels) and
\code{colors} (the contour colors) that can be used for a legend.
}
\description{
Computes and draws density contour lines.
}
\details{
Two-dimensional kernel density estimation with an axis-aligned bivariate
normal kernel. Normal kernel is evaluated on a square grid, after an
isometric log ratio transformation of the original data.
}
\note{
Two-dimensional kernel density estimation is adapted from \code{\link[MASS:kde2d]{MASS::kde2d()}}.

\strong{This must be considered as experimental and subject to major changes
in a future release.}
}
\examples{
## Add density
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid())
levels <- ternary_density(lava, n = 500, nlevels = 10)

## Add a legend
legend_image <- grDevices::as.raster(rev(levels$colors))
graphics::rasterImage(legend_image, 0.85, 0.75, 0.9, 1)
graphics::text(x = 0.9, y = c(0.75, 1), labels = range(levels$levels), pos = 4)
}
\seealso{
\code{\link[grDevices:contourLines]{grDevices::contourLines()}}

Other statistics: 
\code{\link{ternary_contour}()},
\code{\link{ternary_ellipse}()},
\code{\link{ternary_hull}()},
\code{\link{ternary_mean}()},
\code{\link{ternary_pca}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
