% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_axes.R
\docType{methods}
\name{ternary_axis}
\alias{ternary_axis}
\title{Add an Axis to a Ternary Plot}
\usage{
ternary_axis(
  side,
  at = NULL,
  labels = TRUE,
  tick = TRUE,
  font = NA,
  lty = "solid",
  lwd = 1,
  lwd.ticks = lwd,
  col = NULL,
  col.ticks = NULL,
  ...
)
}
\arguments{
\item{side}{An \code{\link{integer}} specifying which side of the plot the axis is to
be drawn on. The axis is placed as follows: 1=below, 2=right and 3=left.}

\item{at}{A \code{\link{numeric}} vector giving the points at which tick-marks are to
be drawn.}

\item{labels}{A \code{\link{logical}} scalar specifying whether (numerical) annotations
are to be made at the tickmarks, or a \code{\link{character}} vector of labels to be
placed at the tickpoints. If this is not \code{logical}, \code{at} should also be
supplied and of the same length.}

\item{tick}{A \code{\link{logical}} scalar: should tickmarks and an axis line be drawn?}

\item{font}{font for text. Defaults to \code{par("font.axis")}.}

\item{lty}{A \code{\link{character}} string or \code{\link{numeric}} value specifying the line
type for both the axis line and the tick marks.}

\item{lwd, lwd.ticks}{A non-negative \code{\link{numeric}} value specifying the line
widths for the axis line and the tick marks.}

\item{col, col.ticks}{Colors for the axis line and the tick marks
respectively. Defaults to \code{par("col.axis")}.}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function, particularly, \code{cex.axis}, \code{col.axis} and
\code{font.axis} for axis annotation.}
}
\value{
\code{ternary_axis()} is called it for its side-effects.
}
\description{
Adds an axis to the current plot.
}
\examples{
## Add axis
ternary_plot(NULL, axes = FALSE)
ternary_axis(side = 1, col = "red")
ternary_axis(side = 2, col = "blue")
ternary_axis(side = 3, col = "green")

## Add box and grid
ternary_plot(NULL, axes = FALSE)
ternary_box(lty = "dashed", col = "red")
ternary_grid(lty.primary = "dotted")
}
\seealso{
Other graphical elements: 
\code{\link{ternary_box}()},
\code{\link{ternary_grid}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_plot}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
