% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a18.R
\name{a18_CO2g_H2O}
\alias{a18_CO2g_H2O}
\title{18O/16O fractionation factor between CO2(g) and H2O(l)}
\usage{
a18_CO2g_H2O(temp)
}
\arguments{
\item{temp}{Temperature (°C).}
}
\value{
Returns the 18O/16O fractionation factor.
}
\description{
\code{a18_CO2_H2O()} calculates the 18O/16O fractionation factor
between gaseous CO2 and liquid water.
}
\details{
\deqn{\alpha^{18}_{CO2(g)/H2O(l)} =
(17.604 \times \frac{1}{T} - 0.01793) + 1}
}
\references{
Brenninkmeijer, C. A. M., Kraft, P., & Mook, W. G. (1983).
Oxygen isotope fractionation between CO2 and H2O.
Chemical Geology, 41, 181-190.
\doi{10.1016/S0009-2541(83)80015-1}
}
\seealso{
Other fractionation_factors: 
\code{\link{a13_CO2g_CO2aq}()},
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_H2O_OH}()},
\code{\link{a18_HCO3_H2O}()},
\code{\link{a18_c_H2O}()},
\code{\link{a_A_B}()}
}
\concept{fractionation_factors}
