% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a13.R
\name{a13_CO2g_CO2aq}
\alias{a13_CO2g_CO2aq}
\title{13C/12C fractionation factor between CO2(g) and CO2(aq)}
\usage{
a13_CO2g_CO2aq(temp)
}
\arguments{
\item{temp}{Temperature (°C).}
}
\value{
Returns the 13C/12C fractionation factor.
}
\description{
\code{a13_CO2g_CO2aq()} calculates the 13C/12C fractionation factor
between gaseous and dissolved CO2.
}
\details{
\deqn{\alpha^{13}_{CO2(g)/CO2(aq)} =
(\frac{-1.18 + 0.0041 \times (T - 273.15)}{1000} + 1)^{-1}}
}
\references{
Vogel, J. C., Grootes, P. M., & Mook, W. G. (1970).
Isotopic fractionation between gaseous and dissolved carbon dioxide.
Zeitschrift für Physik A: Hadrons and Nuclei, 230(3), 225-238.
\doi{10.1007/Bf01394688}
}
\seealso{
Other fractionation_factors: 
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO2g_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_H2O_OH}()},
\code{\link{a18_HCO3_H2O}()},
\code{\link{a18_c_H2O}()},
\code{\link{a_A_B}()}
}
\concept{fractionation_factors}
