% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc_isco_crosswalk.R
\name{soc_isco_crosswalk}
\alias{soc_isco_crosswalk}
\title{SOC to ISCO crosswalk}
\usage{
soc_isco_crosswalk(
  data,
  soc_lvl,
  isco_lvl,
  brkd_cols = NULL,
  indicator = FALSE
)
}
\arguments{
\item{data, }{data.table with mandatory columns \code{job} and \code{value}}

\item{soc_lvl, }{character taking values from \code{soc_1} to \code{soc_4}}

\item{isco_lvl, }{numeric between 1 and 4}

\item{brkd_cols, }{character vector with col names of stratification variables}

\item{indicator, }{Boolean indicating if data describe an indicator. If \code{TRUE}
the mean value is computed, otherwise the sum by each breakdown group.}
}
\value{
\code{data.table} with the estimated values for the requested ISCO
occupational level.
}
\description{
The 2010 Standard Occupational Classification (SOC) and the
International Standard Classification of Occupations (ISCO-08) are compared.
To make the crosswalk more straightforward and hence more useful, the notion
of parsimony was applied. This means that while a task completed in the SOC
may appear in numerous ISCOs (or vice versa), the match in some of these
instances is just coincidental and adds unneeded complexity. This function
allows mapping of data from the 4 SOC groups to the 4 ISCO levels.
}
\examples{
library(iscoCrosswalks)
library(data.table)
#from soc_3 group to ISCO level 1 occupations
path <- system.file("extdata", "soc_3_brkdwn_example.csv",
                    package = "iscoCrosswalks")
dat <- fread(path)
soc_isco_crosswalk(dat,
                   soc_lvl = "soc_3",
                   isco_lvl = 1,
                   brkd_cols = "gender")
}
\references{
\insertRef{hardy2018educational}{iscoCrosswalks}
}
