% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatools.R
\name{isa_node_add}
\alias{isa_node_add}
\alias{isa_node_rm}
\alias{isa_property_add}
\alias{isa_property_rm}
\title{Add or remove nodes and properties}
\usage{
isa_node_add(x, node, columns = NULL, after_node = NULL)

isa_node_rm(x, node_id)

isa_property_add(x, property, values = NA, node_id = NULL, after_id = NULL)

isa_property_rm(x, prop_ids = NULL)
}
\arguments{
\item{x}{isatab object}

\item{node}{new node identifier (e.g. 'Sample Name')}

\item{columns}{(optional) character vector with columns to add}

\item{after_node}{ID of the node after which the current node should be
inserted}

\item{node_id}{ID of the node in which to add the property (default:
last node in the isatab).}

\item{property}{Character vector with identifiers (such as 'Comment[Important]') of the properties to be inserted}

\item{values}{vector (if only one property is added) or data frame (if
multiple properties are added) of values used to initialize the node /
parameter. If multiple properties are added with one call (the length of
the \code{property} vector is greater than one), and values is
a data frame, than it has to have sufficient number of columns
corresponding to the \code{property} vector.}

\item{after_id}{ID of the property after which the parameter should
be inserted (deault: last property)}

\item{prop_ids}{IDs of the properties to be removed}
}
\value{
These functions return an object of isatab-class.
}
\description{
Add or remove nodes and properties
}
\details{
These functions manipulate the structure of an isatab. \code{isa_node_add}
and \code{isa_node_rm} add or remove whole nodes.

To add or remove properties (individual columns which are not nodes) belonging to a given
node, use \code{isa_property_add} and \code{isa_property_rm}.

Adding and removing nodes is easier using brackets / subscripts. Read
the documentation for \code{\linkS4class{isatab}} for details.

Note: IDs are a thing internal to this R package. They are not imported
from or exported to actual ISA-tab files. However, given that the node
'identifiers' (e.g. 'Sample Name') can be ambiguous, IDs are necessary
to unambiguously identify a node.
}
\examples{
file <- system.file('extdata', 's_isatab.txt', package='isaeditor')
isa_s <- read_isa(file)
isa_s <- isa_node_add(isa_s, 'Library Name', columns='Comment[Raw File]')
isa_nodes(isa_s)
isa_s <- isa_property_add(isa_s, 'Characteristics[Age]', values=c(75, 38, 43), node_id='ID1')
}
\seealso{
\code{\linkS4class{isatab}}
}
