% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot.Item}
\alias{plot.Item}
\title{Plot Item Characteristic Curve of an \code{Item} object}
\usage{
\method{plot}{Item}(
  x,
  theta_range = c(-4, 4),
  title = "",
  suppress_plot = FALSE,
  category_names = FALSE,
  legend_title = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{\link{Item-class}} object.}

\item{theta_range}{The boundaries of x axis.}

\item{title}{Title of the plot. By default if the item is 1-4PM IRT model
then the title will be "Item Characteristic Curve" if the item
follows Graded Response Model the title will be
"Category Response Functions". Set it \code{NULL} to remove it.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{category_names}{If the model used is 'GRM' (Graded Response Model)
these names will serve as category names. For example,
c("Strongly Disagree", "Disagree", "Agree", "Strongly Agree").
The default is \code{FALSE} where the default category scores
will be printed. If the value is \code{NULL} no legend will be
printed but the categories will be printed differently.}

\item{legend_title}{The title of the plot's legend.}

\item{...}{Additional arguments that will be passed to \code{geom_line}}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item characteristic curve or returns the plot object.
}
\description{
\code{plot.Item} Plots the item characteristic curve.
}
\examples{
plot(x = item(b = 0.3, D = 1))

item <- item(a = 1.2, b = 0.3, c = .2)
plot(item)
plot(item(a = 1.2, b = 0.3, c = .2, d = .89, D = 1))

# Plot Graded Response Model
ip <- item(a = 0.902, b = c(-1.411, 0.385, 1.79), model = "GRM")
plot(ip)
plot(ip, category_names = c("Strongly Disagree", "Disagree", "Agree",
                            "Strongly Agree"))
ip <- item(a = 0.8, b = 1, model = "GRM")
plot(ip, category_names = c("Incorrect", "Correct"), legend_title = "Response")

# # Change the y-axis label
# plot(ip, suppress_plot = TRUE) + ylab("New Label")

}
\author{
Emre Gonulates
}
