% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_remove_missing.R
\name{ir_remove_missing}
\alias{ir_remove_missing}
\title{Removes empty data values in an object of class \code{ir}}
\usage{
ir_remove_missing(x, remove_rows = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{remove_rows}{A logical value indicating if rows in \code{x} with empty
spectra should be discarded (\code{remove_rows = TRUE}) or not
(\code{remove_rows = FALSE}).}
}
\value{
\code{x} with cleaned spectra.
}
\description{
\code{ir_remove_missing} takes and object of class \code{ir} and removes all
rows in the \code{data.frame}s of the list column \code{spectra} that have
\code{NA} intensity values (column \code{y}). Additionally, one can specify
to remove rows in the \code{ir} object to discard if they contain empty
spectra.
}
\examples{
# create sample data with some missing rows and one entire missing spectra
x <-
   ir::ir_sample_data
x$spectra[[1]] <- x$spectra[[1]][0, ]
x$spectra[[2]][1:100, "y"] <- NA_real_

# remove missing values (but remove no rows in x)
x1 <-
   x \%>\%
   ir::ir_remove_missing(remove_rows = FALSE)

# remove missing values (and remove rows in x if a compete spectrum is
# missing)
x2 <-
   x \%>\%
   ir::ir_remove_missing(remove_rows = TRUE)

nrow(x)
nrow(x1)
nrow(x2)

}
