% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind}
\alias{bind}
\alias{rbind.ir}
\alias{cbind.ir}
\title{Bind rows of \code{ir} objects}
\usage{
\method{rbind}{ir}(..., deparse.level = 1)

\method{cbind}{ir}(..., deparse.level = 1)
}
\arguments{
\item{...}{Objects to bind together. For \code{cbind}, only the first of the
objects is allowed to be of class \code{ir}.}

\item{deparse.level}{An integer value; see \code{\link[=rbind]{rbind()}}.}
}
\value{
An object of class \code{ir}. \code{rbind} returns all input
\code{ir} objects combined row-wise. \code{cbind} returns the input \code{ir}
object and the other objects combined column-wise.
}
\description{
Bind rows of \code{ir} objects
}
\examples{
# rbind
rbind(ir_sample_data, ir_sample_data)
rbind(ir_sample_data \%>\% dplyr::select(spectra),
      ir_sample_data \%>\% dplyr::select(spectra))

# cbind
cbind(ir_sample_data, a = seq_len(nrow(ir_sample_data)))

}
