% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{submit_extract}
\alias{submit_extract}
\title{Submit an extract request via the IPUMS API}
\usage{
submit_extract(extract, api_key = Sys.getenv("IPUMS_API_KEY"))
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{api_key}{API key associated with your user account. Defaults to the
value of environment variable "IPUMS_API_KEY".}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object containing the
extract definition and newly-assigned extract number of the submitted
extract.
}
\description{
Given an \code{\link[=ipums_extract-class]{ipums_extract}} object, submit an extract
request via the IPUMS API, and return a modified copy of the extract object
with the newly-assigned extract number. For an overview of ipumsr microdata API
functionality, see \code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
my_extract <- define_extract_usa("Example", "us2013a", "YEAR")

\dontrun{
# `submit_extract()` returns an ipums_extract object updated to include the
# extract number, so it is often useful to name the return object:
submitted_extract <- submit_extract(my_extract)

# If you didn't capture the return object of submit_extract for your most
# recent extract, you can recover that information with:
submitted_extract <- get_last_extract_info("usa")

# View the extract number
submitted_extract$number

# Check if submitted extract is ready
is_extract_ready(submitted_extract) # returns TRUE or FALSE

# Or have R check periodically until the extract is ready
downloadable_extract <- wait_for_extract(submitted_extract)
}

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
