% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ip_in_range}
\alias{ip_in_range}
\title{check if IP addresses fall within particular IP ranges}
\usage{
ip_in_range(ip_addresses, ranges)
}
\arguments{
\item{ip_addresses}{a vector of IP addresses}

\item{ranges}{either a vector of ranges equal in length
to \code{ip_addresses}, or a single range. If the former,
\code{ip_in_range} will compare each IP to the
equivalent range. If the latter, each IP will be
compared to the single range provided.}
}
\value{
a logical vector, where TRUE indicates the relevant
IP is in the range, and FALSE indicates that the IP
is not in the range, or is an invalid IP address.
}
\description{
\code{ip_in_range} checks whether a vector of IP
addresses fall within particular IP range(s).
}
\examples{
#Is this in the range? Yes!
ip_in_range("172.18.0.1","172.18.0.0/28")
#[1] TRUE

}
\seealso{
\code{\link{range_boundaries}} for identifying the minimum
and maximum IPs within a range, and \code{\link{validate_range}} for
validating that a range exists.
}

