% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forceEqualTipHeights.R
\name{forceEqualTipHeights}
\alias{forceEqualTipHeights}
\title{Equal Tip Heights}
\usage{
forceEqualTipHeights(phy, baseline = "mean")
}
\arguments{
\item{phy}{An object of class \code{\link[ape]{phylo}}.}

\item{baseline}{A character string giving a function to calculate the
baseline tip height, e.g. \code{"min"}, \code{"max"} or \code{"mean"}.}
}
\value{
An object of class \code{\link[ape]{phylo}} with changed terminal
  edge lengths.
}
\description{
Modify terminal edge lengths to create "exactly" (see Details)
  equal tip heights (sum of edge lengths from root to tip)
}
\details{
What is "exactly" equal depends on the precision of the system
  (\code{\link{.Machine}}); in any case the resulting phylogeny will pass
  \code{\link{is.ultrametric}} with default arguments.
}
\note{
\code{forceEqualTipHeights} is only intended to correct small rounding
  errors in edge lengths, not to make an additive phylogeny ultrametric. For
  the latter, see e.g. \code{\link{chronos}}.
}
\seealso{
\code{\link{tipHeights}}
}
